"use strict";

var _interopRequireDefault = require("@babel/runtime-corejs3/helpers/interopRequireDefault");
exports.__esModule = true;
exports.default = void 0;
var _stampit = _interopRequireDefault(require("stampit"));
var _ramda = require("ramda");
var _apidomCore = require("@swagger-api/apidom-core");
var _Parameter = _interopRequireDefault(require("../../../../elements/Parameter.cjs"));
var _FixedFieldsVisitor = _interopRequireDefault(require("../../generics/FixedFieldsVisitor.cjs"));
var _FallbackVisitor = _interopRequireDefault(require("../../FallbackVisitor.cjs"));
var _predicates = require("../../../../predicates.cjs");
const ParameterVisitor = (0, _stampit.default)(_FixedFieldsVisitor.default, _FallbackVisitor.default, {
  props: {
    specPath: (0, _ramda.always)(['document', 'objects', 'Parameter']),
    canSupportSpecificationExtensions: true
  },
  init() {
    this.element = new _Parameter.default();
  },
  methods: {
    ObjectElement(objectElement) {
      // @ts-ignore
      const result = _FixedFieldsVisitor.default.compose.methods.ObjectElement.call(this, objectElement);

      // decorate every MediaTypeElement with media type metadata
      if ((0, _apidomCore.isObjectElement)(this.element.contentProp)) {
        this.element.contentProp.filter(_predicates.isMediaTypeElement).forEach((mediaTypeElement, key) => {
          mediaTypeElement.setMetaProperty('media-type', key.toValue());
        });
      }
      return result;
    }
  }
});
var _default = ParameterVisitor;
exports.default = _default;