import { isStringElement, isObjectElement } from '@swagger-api/apidom-core';
import { startsWith } from 'ramda';

// eslint-disable-next-line @typescript-eslint/naming-convention
export const isOpenApi3_0LikeElement = element => {
  // @ts-ignore
  return isObjectElement(element) && element.hasKey('openapi') && element.hasKey('info');
};
export const isParameterLikeElement = element => {
  // @ts-ignore
  return isObjectElement(element) && element.hasKey('name') && element.hasKey('in');
};
export const isReferenceLikeElement = element => {
  // @ts-ignore
  return isObjectElement(element) && element.hasKey('$ref');
};
export const isRequestBodyLikeElement = element => {
  // @ts-ignore
  return isObjectElement(element) && element.hasKey('content');
};
export const isResponseLikeElement = element => {
  // @ts-ignore
  return isObjectElement(element) && element.hasKey('description');
};
export const isServerLikeElement = isObjectElement;
export const isTagLikeElement = isObjectElement;
export const isOpenApiExtension = element => {
  // @ts-ignore
  return isStringElement(element.key) && startsWith('x-', element.key.toValue());
};