import stampit from 'stampit';
import ComponentsSchemasElement from "../../../../elements/nces/ComponentsSchemas.js";
import MapVisitor from "../../generics/MapVisitor.js";
import FallbackVisitor from "../../FallbackVisitor.js";
import { isReferenceLikeElement } from "../../../predicates.js";
import { isReferenceElement } from "../../../../predicates.js";
const SchemasVisitor = stampit(MapVisitor, FallbackVisitor, {
  props: {
    specPath: element => {
      // eslint-disable-next-line no-nested-ternary
      return isReferenceLikeElement(element) ? ['document', 'objects', 'Reference'] : ['document', 'objects', 'Schema'];
    }
  },
  init() {
    this.element = new ComponentsSchemasElement();
  },
  methods: {
    ObjectElement(objectElement) {
      // @ts-ignore
      const result = MapVisitor.compose.methods.ObjectElement.call(this, objectElement);

      // decorate every ReferenceElement with metadata about their referencing type
      this.element.filter(isReferenceElement).forEach(referenceElement => {
        referenceElement.setMetaProperty('referenced-element', 'schema');
      });
      return result;
    }
  }
});
export default SchemasVisitor;