import stampit from 'stampit';
import { always } from 'ramda';
import { isStringElement } from '@swagger-api/apidom-core';
import ExampleElement from "../../../../elements/Example.js";
import FallbackVisitor from "../../FallbackVisitor.js";
import FixedFieldsVisitor from "../../generics/FixedFieldsVisitor.js";
const ExampleVisitor = stampit(FixedFieldsVisitor, FallbackVisitor, {
  props: {
    specPath: always(['document', 'objects', 'Example']),
    canSupportSpecificationExtensions: true
  },
  init() {
    this.element = new ExampleElement();
  },
  methods: {
    ObjectElement(objectElement) {
      // @ts-ignore
      const result = FixedFieldsVisitor.compose.methods.ObjectElement.call(this, objectElement);

      // mark this ExampleElement with reference metadata
      if (isStringElement(this.element.externalValue)) {
        this.element.classes.push('reference-element');
      }
      return result;
    }
  }
});
export default ExampleVisitor;