import stampit from 'stampit';
import { T as stubTrue } from 'ramda';
import AlternatingVisitor from "../../generics/AlternatingVisitor.js";
import FallbackVisitor from "../../FallbackVisitor.js";
import { isReferenceLikeElement } from "../../../predicates.js";
import { isReferenceElement } from "../../../../predicates.js";
const SchemaVisitor = stampit(AlternatingVisitor, FallbackVisitor, {
  props: {
    alternator: [{
      predicate: isReferenceLikeElement,
      specPath: ['document', 'objects', 'Reference']
    }, {
      predicate: stubTrue,
      specPath: ['document', 'objects', 'Schema']
    }]
  },
  methods: {
    ObjectElement(objectElement) {
      // @ts-ignore
      const result = AlternatingVisitor.compose.methods.enter.call(this, objectElement);
      if (isReferenceElement(this.element)) {
        this.element.setMetaProperty('referenced-element', 'schema');
      }
      return result;
    }
  }
});
export default SchemaVisitor;