import stampit from 'stampit';
import { always } from 'ramda';
import { isStringElement } from '@swagger-api/apidom-core';
import PathItemElement from "../../../../elements/PathItem.js";
import { isOperationElement } from "../../../../predicates.js";
import FixedFieldsVisitor from "../../generics/FixedFieldsVisitor.js";
import FallbackVisitor from "../../FallbackVisitor.js";
const PathItemVisitor = stampit(FixedFieldsVisitor, FallbackVisitor, {
  props: {
    specPath: always(['document', 'objects', 'PathItem'])
  },
  init() {
    this.element = new PathItemElement();
  },
  methods: {
    ObjectElement(objectElement) {
      // @ts-ignore
      const result = FixedFieldsVisitor.compose.methods.ObjectElement.call(this, objectElement);

      // decorate Operation elements with HTTP method
      this.element.filter(isOperationElement).forEach((operationElement, httpMethodElementCI) => {
        const httpMethodElementCS = httpMethodElementCI.clone();
        httpMethodElementCS.content = httpMethodElementCS.toValue().toUpperCase();
        operationElement.setMetaProperty('http-method', httpMethodElementCS);
      });

      // mark this PathItemElement with reference metadata
      if (isStringElement(this.element.$ref)) {
        this.element.classes.push('reference-element');
      }
      return result;
    }
  }
});
export default PathItemVisitor;