import stampit from 'stampit';
import { test, always } from 'ramda';
import PathsElement from "../../../../elements/Paths.js";
import PatternedFieldsVisitor from "../../generics/PatternedFieldsVisitor.js";
import FallbackVisitor from "../../FallbackVisitor.js";
import { isPathItemElement } from "../../../../predicates.js";
const PathsVisitor = stampit(PatternedFieldsVisitor, FallbackVisitor, {
  props: {
    fieldPatternPredicate: test(/^\/(?<path>.*)$/),
    specPath: always(['document', 'objects', 'PathItem']),
    canSupportSpecificationExtensions: true
  },
  init() {
    this.element = new PathsElement();
  },
  methods: {
    ObjectElement(objectElement) {
      // @ts-ignore
      const result = PatternedFieldsVisitor.compose.methods.ObjectElement.call(this, objectElement);

      // decorate every PathItemElement with path metadata
      this.element.filter(isPathItemElement).forEach((pathItemElement, key) => {
        pathItemElement.setMetaProperty('path', key.clone());
      });
      return result;
    }
  }
});
export default PathsVisitor;