import stampit from 'stampit';
import { always } from 'ramda';
import { isObjectElement } from '@swagger-api/apidom-core';
import ResponseElement from "../../../../elements/Response.js";
import FixedFieldsVisitor from "../../generics/FixedFieldsVisitor.js";
import FallbackVisitor from "../../FallbackVisitor.js";
import { isHeaderElement, isMediaTypeElement } from "../../../../predicates.js";
const ResponseVisitor = stampit(FixedFieldsVisitor, FallbackVisitor, {
  props: {
    specPath: always(['document', 'objects', 'Response'])
  },
  init() {
    this.element = new ResponseElement();
  },
  methods: {
    ObjectElement(objectElement) {
      // @ts-ignore
      const result = FixedFieldsVisitor.compose.methods.ObjectElement.call(this, objectElement);

      // decorate every MediaTypeElement with media type metadata
      if (isObjectElement(this.element.contentProp)) {
        this.element.contentProp.filter(isMediaTypeElement).forEach((mediaTypeElement, key) => {
          mediaTypeElement.setMetaProperty('media-type', key.toValue());
        });
      }

      // decorate every MediaTypeElement with media type metadata
      if (isObjectElement(this.element.headers)) {
        this.element.headers.filter(isHeaderElement).forEach((headerElement, key) => {
          headerElement.setMetaProperty('header-name', key.toValue());
        });
      }
      return result;
    }
  }
});
export default ResponseVisitor;