"use strict";

var _interopRequireDefault = require("@babel/runtime-corejs3/helpers/interopRequireDefault");
exports.__esModule = true;
exports.isServerVariableElement = exports.isServerElement = exports.isSecurityRequirementElement = exports.isSchemaElement = exports.isResponsesElement = exports.isResponseElement = exports.isRequestBodyElement = exports.isReferenceElementExternal = exports.isReferenceElement = exports.isPathsElement = exports.isPathItemElementExternal = exports.isPathItemElement = exports.isParameterElement = exports.isOperationElement = exports.isOpenapiElement = exports.isOpenApi3_0Element = exports.isMediaTypeElement = exports.isLinkElementExternal = exports.isLinkElement = exports.isLicenseElement = exports.isInfoElement = exports.isHeaderElement = exports.isExternalDocumentationElement = exports.isExampleElement = exports.isContactElement = exports.isComponentsElement = exports.isCallbackElement = exports.isBooleanJsonSchemaElement = void 0;
var _apidomCore = require("@swagger-api/apidom-core");
var _Callback = _interopRequireDefault(require("./elements/Callback.cjs"));
var _Components = _interopRequireDefault(require("./elements/Components.cjs"));
var _Contact = _interopRequireDefault(require("./elements/Contact.cjs"));
var _Example = _interopRequireDefault(require("./elements/Example.cjs"));
var _ExternalDocumentation = _interopRequireDefault(require("./elements/ExternalDocumentation.cjs"));
var _Header = _interopRequireDefault(require("./elements/Header.cjs"));
var _Info = _interopRequireDefault(require("./elements/Info.cjs"));
var _License = _interopRequireDefault(require("./elements/License.cjs"));
var _Link = _interopRequireDefault(require("./elements/Link.cjs"));
var _Openapi = _interopRequireDefault(require("./elements/Openapi.cjs"));
var _OpenApi = _interopRequireDefault(require("./elements/OpenApi3-0.cjs"));
var _Operation = _interopRequireDefault(require("./elements/Operation.cjs"));
var _Parameter = _interopRequireDefault(require("./elements/Parameter.cjs"));
var _PathItem = _interopRequireDefault(require("./elements/PathItem.cjs"));
var _Paths = _interopRequireDefault(require("./elements/Paths.cjs"));
var _Reference = _interopRequireDefault(require("./elements/Reference.cjs"));
var _RequestBody = _interopRequireDefault(require("./elements/RequestBody.cjs"));
var _Response = _interopRequireDefault(require("./elements/Response.cjs"));
var _Responses = _interopRequireDefault(require("./elements/Responses.cjs"));
var _Schema = _interopRequireDefault(require("./elements/Schema.cjs"));
var _SecurityRequirement = _interopRequireDefault(require("./elements/SecurityRequirement.cjs"));
var _Server = _interopRequireDefault(require("./elements/Server.cjs"));
var _ServerVariable = _interopRequireDefault(require("./elements/ServerVariable.cjs"));
var _MediaType = _interopRequireDefault(require("./elements/MediaType.cjs"));
const isCallbackElement = (0, _apidomCore.createPredicate)(({
  hasBasicElementProps,
  isElementType,
  primitiveEq
}) => {
  return element => element instanceof _Callback.default || hasBasicElementProps(element) && isElementType('callback', element) && primitiveEq('object', element);
});
exports.isCallbackElement = isCallbackElement;
const isComponentsElement = (0, _apidomCore.createPredicate)(({
  hasBasicElementProps,
  isElementType,
  primitiveEq
}) => {
  return element => element instanceof _Components.default || hasBasicElementProps(element) && isElementType('components', element) && primitiveEq('object', element);
});
exports.isComponentsElement = isComponentsElement;
const isContactElement = (0, _apidomCore.createPredicate)(({
  hasBasicElementProps,
  isElementType,
  primitiveEq
}) => {
  return element => element instanceof _Contact.default || hasBasicElementProps(element) && isElementType('contact', element) && primitiveEq('object', element);
});
exports.isContactElement = isContactElement;
const isExampleElement = (0, _apidomCore.createPredicate)(({
  hasBasicElementProps,
  isElementType,
  primitiveEq
}) => {
  return element => element instanceof _Example.default || hasBasicElementProps(element) && isElementType('example', element) && primitiveEq('object', element);
});
exports.isExampleElement = isExampleElement;
const isExternalDocumentationElement = (0, _apidomCore.createPredicate)(({
  hasBasicElementProps,
  isElementType,
  primitiveEq
}) => {
  return element => element instanceof _ExternalDocumentation.default || hasBasicElementProps(element) && isElementType('externalDocumentation', element) && primitiveEq('object', element);
});
exports.isExternalDocumentationElement = isExternalDocumentationElement;
const isHeaderElement = (0, _apidomCore.createPredicate)(({
  hasBasicElementProps,
  isElementType,
  primitiveEq
}) => {
  return element => element instanceof _Header.default || hasBasicElementProps(element) && isElementType('header', element) && primitiveEq('object', element);
});
exports.isHeaderElement = isHeaderElement;
const isInfoElement = (0, _apidomCore.createPredicate)(({
  hasBasicElementProps,
  isElementType,
  primitiveEq
}) => {
  return element => element instanceof _Info.default || hasBasicElementProps(element) && isElementType('info', element) && primitiveEq('object', element);
});
exports.isInfoElement = isInfoElement;
const isLicenseElement = (0, _apidomCore.createPredicate)(({
  hasBasicElementProps,
  isElementType,
  primitiveEq
}) => {
  return element => element instanceof _License.default || hasBasicElementProps(element) && isElementType('license', element) && primitiveEq('object', element);
});
exports.isLicenseElement = isLicenseElement;
const isLinkElement = (0, _apidomCore.createPredicate)(({
  hasBasicElementProps,
  isElementType,
  primitiveEq
}) => {
  return element => element instanceof _Link.default || hasBasicElementProps(element) && isElementType('link', element) && primitiveEq('object', element);
});
exports.isLinkElement = isLinkElement;
const isLinkElementExternal = element => {
  if (!isLinkElement(element)) {
    return false;
  }
  if (!(0, _apidomCore.isStringElement)(element.operationRef)) {
    return false;
  }
  const value = element.operationRef.toValue();
  return typeof value === 'string' && value.length > 0 && !value.startsWith('#');
};
exports.isLinkElementExternal = isLinkElementExternal;
const isOpenapiElement = (0, _apidomCore.createPredicate)(({
  hasBasicElementProps,
  isElementType,
  primitiveEq
}) => {
  return element => element instanceof _Openapi.default || hasBasicElementProps(element) && isElementType('openapi', element) && primitiveEq('string', element);
});

// eslint-disable-next-line @typescript-eslint/naming-convention
exports.isOpenapiElement = isOpenapiElement;
const isOpenApi3_0Element = (0, _apidomCore.createPredicate)(({
  hasBasicElementProps,
  isElementType,
  primitiveEq,
  hasClass
}) => {
  return element => element instanceof _OpenApi.default || hasBasicElementProps(element) && isElementType('openApi3_0', element) && primitiveEq('object', element) && hasClass('api', element);
});
exports.isOpenApi3_0Element = isOpenApi3_0Element;
const isOperationElement = (0, _apidomCore.createPredicate)(({
  hasBasicElementProps,
  isElementType,
  primitiveEq
}) => {
  return element => element instanceof _Operation.default || hasBasicElementProps(element) && isElementType('operation', element) && primitiveEq('object', element);
});
exports.isOperationElement = isOperationElement;
const isParameterElement = (0, _apidomCore.createPredicate)(({
  hasBasicElementProps,
  isElementType,
  primitiveEq
}) => {
  return element => element instanceof _Parameter.default || hasBasicElementProps(element) && isElementType('parameter', element) && primitiveEq('object', element);
});
exports.isParameterElement = isParameterElement;
const isPathItemElement = (0, _apidomCore.createPredicate)(({
  hasBasicElementProps,
  isElementType,
  primitiveEq
}) => {
  return element => element instanceof _PathItem.default || hasBasicElementProps(element) && isElementType('pathItem', element) && primitiveEq('object', element);
});
exports.isPathItemElement = isPathItemElement;
const isPathItemElementExternal = element => {
  if (!isPathItemElement(element)) {
    return false;
  }
  if (!(0, _apidomCore.isStringElement)(element.$ref)) {
    return false;
  }
  const value = element.$ref.toValue();
  return typeof value === 'string' && value.length > 0 && !value.startsWith('#');
};
exports.isPathItemElementExternal = isPathItemElementExternal;
const isPathsElement = (0, _apidomCore.createPredicate)(({
  hasBasicElementProps,
  isElementType,
  primitiveEq
}) => {
  return element => element instanceof _Paths.default || hasBasicElementProps(element) && isElementType('paths', element) && primitiveEq('object', element);
});
exports.isPathsElement = isPathsElement;
const isReferenceElement = (0, _apidomCore.createPredicate)(({
  hasBasicElementProps,
  isElementType,
  primitiveEq
}) => {
  return element => element instanceof _Reference.default || hasBasicElementProps(element) && isElementType('reference', element) && primitiveEq('object', element);
});
exports.isReferenceElement = isReferenceElement;
const isReferenceElementExternal = element => {
  if (!isReferenceElement(element)) {
    return false;
  }
  if (!(0, _apidomCore.isStringElement)(element.$ref)) {
    return false;
  }
  const value = element.$ref.toValue();
  return typeof value === 'string' && value.length > 0 && !value.startsWith('#');
};
exports.isReferenceElementExternal = isReferenceElementExternal;
const isRequestBodyElement = (0, _apidomCore.createPredicate)(({
  hasBasicElementProps,
  isElementType,
  primitiveEq
}) => {
  return element => element instanceof _RequestBody.default || hasBasicElementProps(element) && isElementType('requestBody', element) && primitiveEq('object', element);
});
exports.isRequestBodyElement = isRequestBodyElement;
const isResponseElement = (0, _apidomCore.createPredicate)(({
  hasBasicElementProps,
  isElementType,
  primitiveEq
}) => {
  return element => element instanceof _Response.default || hasBasicElementProps(element) && isElementType('response', element) && primitiveEq('object', element);
});
exports.isResponseElement = isResponseElement;
const isResponsesElement = (0, _apidomCore.createPredicate)(({
  hasBasicElementProps,
  isElementType,
  primitiveEq
}) => {
  return element => element instanceof _Responses.default || hasBasicElementProps(element) && isElementType('responses', element) && primitiveEq('object', element);
});
exports.isResponsesElement = isResponsesElement;
const isSchemaElement = (0, _apidomCore.createPredicate)(({
  hasBasicElementProps,
  isElementType,
  primitiveEq
}) => {
  return element => element instanceof _Schema.default || hasBasicElementProps(element) && isElementType('schema', element) && primitiveEq('object', element);
});
exports.isSchemaElement = isSchemaElement;
const isBooleanJsonSchemaElement = element => {
  return (0, _apidomCore.isBooleanElement)(element) && element.classes.includes('boolean-json-schema');
};
exports.isBooleanJsonSchemaElement = isBooleanJsonSchemaElement;
const isSecurityRequirementElement = (0, _apidomCore.createPredicate)(({
  hasBasicElementProps,
  isElementType,
  primitiveEq
}) => {
  return element => element instanceof _SecurityRequirement.default || hasBasicElementProps(element) && isElementType('securityRequirement', element) && primitiveEq('object', element);
});
exports.isSecurityRequirementElement = isSecurityRequirementElement;
const isServerElement = (0, _apidomCore.createPredicate)(({
  hasBasicElementProps,
  isElementType,
  primitiveEq
}) => {
  return element => element instanceof _Server.default || hasBasicElementProps(element) && isElementType('server', element) && primitiveEq('object', element);
});
exports.isServerElement = isServerElement;
const isServerVariableElement = (0, _apidomCore.createPredicate)(({
  hasBasicElementProps,
  isElementType,
  primitiveEq
}) => {
  return element => element instanceof _ServerVariable.default || hasBasicElementProps(element) && isElementType('serverVariable', element) && primitiveEq('object', element);
});
exports.isServerVariableElement = isServerVariableElement;
const isMediaTypeElement = (0, _apidomCore.createPredicate)(({
  hasBasicElementProps,
  isElementType,
  primitiveEq
}) => {
  return element => element instanceof _MediaType.default || hasBasicElementProps(element) && isElementType('mediaType', element) && primitiveEq('object', element);
});
exports.isMediaTypeElement = isMediaTypeElement;