"use strict";

exports.__esModule = true;
exports.isTagLikeElement = exports.isServerLikeElement = exports.isResponseLikeElement = exports.isRequestBodyLikeElement = exports.isReferenceLikeElement = exports.isParameterLikeElement = exports.isOpenApiExtension = exports.isOpenApi3_0LikeElement = void 0;
var _apidomCore = require("@swagger-api/apidom-core");
var _ramda = require("ramda");
// eslint-disable-next-line @typescript-eslint/naming-convention
const isOpenApi3_0LikeElement = element => {
  // @ts-ignore
  return (0, _apidomCore.isObjectElement)(element) && element.hasKey('openapi') && element.hasKey('info');
};
exports.isOpenApi3_0LikeElement = isOpenApi3_0LikeElement;
const isParameterLikeElement = element => {
  // @ts-ignore
  return (0, _apidomCore.isObjectElement)(element) && element.hasKey('name') && element.hasKey('in');
};
exports.isParameterLikeElement = isParameterLikeElement;
const isReferenceLikeElement = element => {
  // @ts-ignore
  return (0, _apidomCore.isObjectElement)(element) && element.hasKey('$ref');
};
exports.isReferenceLikeElement = isReferenceLikeElement;
const isRequestBodyLikeElement = element => {
  // @ts-ignore
  return (0, _apidomCore.isObjectElement)(element) && element.hasKey('content');
};
exports.isRequestBodyLikeElement = isRequestBodyLikeElement;
const isResponseLikeElement = element => {
  // @ts-ignore
  return (0, _apidomCore.isObjectElement)(element) && element.hasKey('description');
};
exports.isResponseLikeElement = isResponseLikeElement;
const isServerLikeElement = _apidomCore.isObjectElement;
exports.isServerLikeElement = isServerLikeElement;
const isTagLikeElement = _apidomCore.isObjectElement;
exports.isTagLikeElement = isTagLikeElement;
const isOpenApiExtension = element => {
  // @ts-ignore
  return (0, _apidomCore.isStringElement)(element.key) && (0, _ramda.startsWith)('x-', element.key.toValue());
};
exports.isOpenApiExtension = isOpenApiExtension;