"use strict";

var _interopRequireDefault = require("@babel/runtime-corejs3/helpers/interopRequireDefault");
exports.__esModule = true;
exports.default = void 0;
var _stampit = _interopRequireDefault(require("stampit"));
var _ramda = require("ramda");
var _ramdaAdjunct = require("ramda-adjunct");
var _apidomCore = require("@swagger-api/apidom-core");
var _FixedFieldsVisitor = _interopRequireDefault(require("./FixedFieldsVisitor.cjs"));
var _PatternedFieldsVisitor = _interopRequireDefault(require("./PatternedFieldsVisitor.cjs"));
const MixedFieldsVisitor = (0, _stampit.default)(_FixedFieldsVisitor.default, _PatternedFieldsVisitor.default, {
  props: {
    specPathFixedFields: _ramdaAdjunct.noop,
    specPathPatternedFields: _ramdaAdjunct.noop
  },
  methods: {
    ObjectElement(objectElement) {
      const {
        specPath,
        ignoredFields
      } = this;
      try {
        this.specPath = this.specPathFixedFields;
        const fixedFields = this.retrieveFixedFields(this.specPath(objectElement));
        // let FixedFieldsVisitor only process fixed fields and leave rest to PatternedFieldsVisitor
        this.ignoredFields = [...ignoredFields, ...(0, _ramda.difference)(objectElement.keys(), fixedFields)];
        // @ts-ignore
        _FixedFieldsVisitor.default.compose.methods.ObjectElement.call(this, objectElement);
        this.specPath = this.specPathPatternedFields;
        this.ignoredFields = fixedFields;
        // @ts-ignore
        _PatternedFieldsVisitor.default.compose.methods.ObjectElement.call(this, objectElement);
      } catch (e) {
        this.specPath = specPath;
        throw e;
      }
      return _apidomCore.BREAK;
    }
  }
});
var _default = MixedFieldsVisitor;
exports.default = _default;