"use strict";

var _interopRequireDefault = require("@babel/runtime-corejs3/helpers/interopRequireDefault");
exports.__esModule = true;
exports.default = void 0;
var _stampit = _interopRequireDefault(require("stampit"));
var _ramda = require("ramda");
var _ramdaAdjunct = require("ramda-adjunct");
var _apidomCore = require("@swagger-api/apidom-core");
var _SpecificationVisitor = _interopRequireDefault(require("../SpecificationVisitor.cjs"));
var _predicates = require("../../predicates.cjs");
const PatternedFieldsJsonObjectVisitor = (0, _stampit.default)(_SpecificationVisitor.default, {
  props: {
    fieldPatternPredicate: _ramda.F,
    specPath: _ramdaAdjunct.noop,
    ignoredFields: [],
    canSupportSpecificationExtensions: false,
    specificationExtensionPredicate: _predicates.isOpenApiExtension
  },
  init({
    // @ts-ignore
    specPath = this.specPath,
    // @ts-ignore
    ignoredFields = this.ignoredFields,
    // @ts-ignore
    canSupportSpecificationExtensions = this.canSupportSpecificationExtensions,
    // @ts-ignore
    specificationExtensionPredicate = this.specificationExtensionPredicate
  } = {}) {
    this.specPath = specPath;
    this.ignoredFields = ignoredFields;
    this.canSupportSpecificationExtensions = canSupportSpecificationExtensions;
    this.specificationExtensionPredicate = specificationExtensionPredicate;
  },
  methods: {
    ObjectElement(objectElement) {
      // @ts-ignore
      objectElement.forEach((value, key, memberElement) => {
        if (this.canSupportSpecificationExtensions && this.specificationExtensionPredicate(memberElement)) {
          const extensionElement = this.toRefractedElement(['document', 'extension'], memberElement);
          this.element.content.push(extensionElement);
        } else if (!this.ignoredFields.includes(key.toValue()) && this.fieldPatternPredicate(key.toValue())) {
          const specPath = this.specPath(value);
          const patternedFieldElement = this.toRefractedElement(specPath, value);
          const newMemberElement = new _apidomCore.MemberElement(key.clone(), patternedFieldElement);
          this.copyMetaAndAttributes(memberElement, newMemberElement);
          newMemberElement.classes.push('patterned-field');
          this.element.content.push(newMemberElement);
        } else if (!this.ignoredFields.includes(key.toValue())) {
          this.element.content.push(memberElement.clone());
        }
      });
      this.copyMetaAndAttributes(objectElement, this.element);
      return _apidomCore.BREAK;
    }
  }
});
var _default = PatternedFieldsJsonObjectVisitor;
exports.default = _default;