"use strict";

var _interopRequireDefault = require("@babel/runtime-corejs3/helpers/interopRequireDefault");
exports.__esModule = true;
exports.default = void 0;
var _stampit = _interopRequireDefault(require("stampit"));
var _ramda = require("ramda");
var _Paths = _interopRequireDefault(require("../../../../elements/Paths.cjs"));
var _PatternedFieldsVisitor = _interopRequireDefault(require("../../generics/PatternedFieldsVisitor.cjs"));
var _FallbackVisitor = _interopRequireDefault(require("../../FallbackVisitor.cjs"));
var _predicates = require("../../../../predicates.cjs");
const PathsVisitor = (0, _stampit.default)(_PatternedFieldsVisitor.default, _FallbackVisitor.default, {
  props: {
    fieldPatternPredicate: (0, _ramda.test)(/^\/(?<path>.*)$/),
    specPath: (0, _ramda.always)(['document', 'objects', 'PathItem']),
    canSupportSpecificationExtensions: true
  },
  init() {
    this.element = new _Paths.default();
  },
  methods: {
    ObjectElement(objectElement) {
      // @ts-ignore
      const result = _PatternedFieldsVisitor.default.compose.methods.ObjectElement.call(this, objectElement);

      // decorate every PathItemElement with path metadata
      this.element.filter(_predicates.isPathItemElement).forEach((pathItemElement, key) => {
        pathItemElement.setMetaProperty('path', key.clone());
      });
      return result;
    }
  }
});
var _default = PathsVisitor;
exports.default = _default;