import CallbackElement from "./elements/Callback.js";
import ComponentsElement from "./elements/Components.js";
import ContactElement from "./elements/Contact.js";
import DiscriminatorElement from "./elements/Discriminator.js";
import EncodingElement from "./elements/Encoding.js";
import ExampleElement from "./elements/Example.js";
import ExternalDocumentationElement from "./elements/ExternalDocumentation.js";
import HeaderElement from "./elements/Header.js";
import InfoElement from "./elements/Info.js";
import LicenseElement from "./elements/License.js";
import LinkElement from "./elements/Link.js";
import MediaTypeElement from "./elements/MediaType.js";
import OAuthFlowElement from "./elements/OAuthFlow.js";
import OAuthFlowsElement from "./elements/OAuthFlows.js";
import OpenapiElement from "./elements/Openapi.js";
import OpenApi3_0Element from "./elements/OpenApi3-0.js";
import OperationElement from "./elements/Operation.js";
import ParameterElement from "./elements/Parameter.js";
import PathItemElement from "./elements/PathItem.js";
import PathsElement from "./elements/Paths.js";
import ReferenceElement from "./elements/Reference.js";
import RequestBodyElement from "./elements/RequestBody.js";
import ResponseElement from "./elements/Response.js";
import ResponsesElement from "./elements/Responses.js";
import SchemaElement from "./elements/Schema.js";
import SecurityRequirementElement from "./elements/SecurityRequirement.js";
import SecuritySchemeElement from "./elements/SecurityScheme.js";
import ServerElement from "./elements/Server.js";
import ServerVariableElement from "./elements/ServerVariable.js";
import TagElement from "./elements/Tag.js";
import XmlElement from "./elements/Xml.js"; // eslint-disable-next-line @typescript-eslint/naming-convention
const openApi3_0 = {
  namespace: options => {
    const {
      base
    } = options;
    base.register('callback', CallbackElement);
    base.register('components', ComponentsElement);
    base.register('contact', ContactElement);
    base.register('discriminator', DiscriminatorElement);
    base.register('encoding', EncodingElement);
    base.register('example', ExampleElement);
    base.register('externalDocumentation', ExternalDocumentationElement);
    base.register('header', HeaderElement);
    base.register('info', InfoElement);
    base.register('license', LicenseElement);
    base.register('link', LinkElement);
    base.register('mediaType', MediaTypeElement);
    base.register('oAuthFlow', OAuthFlowElement);
    base.register('oAuthFlows', OAuthFlowsElement);
    base.register('openapi', OpenapiElement);
    base.register('openApi3_0', OpenApi3_0Element);
    base.register('operation', OperationElement);
    base.register('parameter', ParameterElement);
    base.register('pathItem', PathItemElement);
    base.register('paths', PathsElement);
    base.register('reference', ReferenceElement);
    base.register('requestBody', RequestBodyElement);
    base.register('response', ResponseElement);
    base.register('responses', ResponsesElement);
    base.register('schema', SchemaElement);
    base.register('securityRequirement', SecurityRequirementElement);
    base.register('securityScheme', SecuritySchemeElement);
    base.register('server', ServerElement);
    base.register('serverVariable', ServerVariableElement);
    base.register('tag', TagElement);
    base.register('xml', XmlElement);
    return base;
  }
};
export default openApi3_0;