import { MemberElement, ArrayElement, ObjectElement, isStringElement, includesClasses, isArrayElement } from '@swagger-api/apidom-core';

/**
 * OpenAPI 3.0.3 specification elements.
 */
import InfoElement from "../../elements/Info.js";
import ContactElement from "../../elements/Contact.js";
import LicenseElement from "../../elements/License.js";
import PathsElement from "../../elements/Paths.js";
import PathItemElement from "../../elements/PathItem.js";
import ComponentsElement from "../../elements/Components.js";
import ExternalDocumentationElement from "../../elements/ExternalDocumentation.js";
import OperationElement from "../../elements/Operation.js";
import SchemaElement from "../../elements/Schema.js";
import RequestBodyElement from "../../elements/RequestBody.js";
import ResponsesElement from "../../elements/Responses.js";
import ResponseElement from "../../elements/Response.js";
import ServerElement from "../../elements/Server.js";
import DiscriminatorElement from "../../elements/Discriminator.js";
import XmlElement from "../../elements/Xml.js";
import OAuthFlowsElement from "../../elements/OAuthFlows.js";
import OAuthFlowElement from "../../elements/OAuthFlow.js";
import ServerVariableElement from "../../elements/ServerVariable.js";
import ParameterElement from "../../elements/Parameter.js";
import ExampleElement from "../../elements/Example.js";
import HeaderElement from "../../elements/Header.js";
import SecuritySchemeElement from "../../elements/SecurityScheme.js";
import LinkElement from "../../elements/Link.js";
import CallbackElement from "../../elements/Callback.js";
import MediaTypeElement from "../../elements/MediaType.js";
import EncodingElement from "../../elements/Encoding.js";
import SecurityRequirementElement from "../../elements/SecurityRequirement.js";
import TagElement from "../../elements/Tag.js"; // non-concrete Elements (NCEs)
import ServersElement from "../../elements/nces/Servers.js";
import SecurityElement from "../../elements/nces/Security.js";
import TagsElement from "../../elements/nces/Tags.js";
import ServerVariablesElement from "../../elements/nces/ServerVariables.js";
import ComponentsSchemasElement from "../../elements/nces/ComponentsSchemas.js";
import ComponentsResponsesElement from "../../elements/nces/ComponentsResponses.js";
import ComponentsParametersElement from "../../elements/nces/ComponentsParameters.js";
import ComponentsExamplesElement from "../../elements/nces/ComponentsExamples.js";
import ComponentsRequestBodiesElement from "../../elements/nces/ComponentsRequestBodies.js";
import ComponentsHeadersElement from "../../elements/nces/ComponentsHeaders.js";
import ComponentsSecuritySchemesElement from "../../elements/nces/ComponentsSecuritySchemes.js";
import ComponentsLinksElement from "../../elements/nces/ComponentsLinks.js";
import ComponentsCallbacksElement from "../../elements/nces/ComponentsCallbacks.js";
import PathItemServersElement from "../../elements/nces/PathItemServers.js";
import PathItemParametersElement from "../../elements/nces/PathItemParameters.js";
import OperationParametersElement from "../../elements/nces/OperationParameters.js";
import ParameterExamplesElement from "../../elements/nces/ParameterExamples.js";
import ParameterContentElement from "../../elements/nces/ParameterContent.js";
import OperationTagsElement from "../../elements/nces/OperationTags.js";
import OperationCallbacksElement from "../../elements/nces/OperationCallbacks.js";
import OperationSecurityElement from "../../elements/nces/OperationSecurity.js";
import OperationServersElement from "../../elements/nces/OperationServers.js";
import RequestBodyContentElement from "../../elements/nces/RequestBodyContent.js";
import MediaTypeExamplesElement from "../../elements/nces/MediaTypeExamples.js";
import MediaTypeEncodingElement from "../../elements/nces/MediaTypeEncoding.js";
import EncodingHeadersElement from "../../elements/nces/EncodingHeaders.js";
import ResponseHeadersElement from "../../elements/nces/ResponseHeaders.js";
import ResponseContentElement from "../../elements/nces/ResponseContent.js";
import ResponseLinksElement from "../../elements/nces/ResponseLinks.js";
import DiscriminatorMappingElement from "../../elements/nces/DiscriminatorMapping.js";
import OAuthFlowScopesElement from "../../elements/nces/OAuthFlowScopes.js";
import LinkParametersElement from "../../elements/nces/LinkParameters.js";
import HeaderExamplesElement from "../../elements/nces/HeaderExamples.js";
import HeaderContentElement from "../../elements/nces/HeaderContent.js";
import { getNodeType } from "../../traversal/visitor.js";
/**
 * This plugin is specific to YAML 1.2 format, which allows defining key-value pairs
 * with empty key, empty value, or both. If the value is not provided in YAML format,
 * this plugin compensates for this missing value with the most appropriate semantic element type.
 *
 * https://yaml.org/spec/1.2.2/#72-empty-nodes
 *
 * @example
 *
 * ```yaml
 * openapi: 3.0.3
 * info:
 * ```
 * Refracting result without this plugin:
 *
 *  (OpenApi3_0Element
 *    (MemberElement
 *      (StringElement)
 *      (OpenapiElement))
 *    (MemberElement
 *      (StringElement)
 *      (StringElement))
 *
 * Refracting result with this plugin:
 *
 *  (OpenApi3_0Element
 *    (MemberElement
 *      (StringElement)
 *      (OpenapiElement))
 *    (MemberElement
 *      (StringElement)
 *      (InfoElement))
 */
const isEmptyElement = element => isStringElement(element) && includesClasses(['yaml-e-node', 'yaml-e-scalar'], element);
const schema = {
  // concrete types handling (CTs)
  OpenApi3_0Element: {
    info(...args) {
      return new InfoElement(...args);
    },
    servers(...args) {
      return new ServersElement(...args);
    },
    paths(...args) {
      return new PathsElement(...args);
    },
    components(...args) {
      return new ComponentsElement(...args);
    },
    security(...args) {
      return new SecurityElement(...args);
    },
    tags(...args) {
      return new TagsElement(...args);
    },
    externalDocs(...args) {
      return new ExternalDocumentationElement(...args);
    }
  },
  InfoElement: {
    contact(...args) {
      return new ContactElement(...args);
    },
    license(...args) {
      return new LicenseElement(...args);
    }
  },
  ServerElement: {
    variables(...args) {
      return new ServerVariablesElement(...args);
    }
  },
  ServerVariableElement: {
    enum(...args) {
      return new ArrayElement(...args);
    }
  },
  PathsElement: {
    '[key: *]': function key(...args) {
      return new PathItemElement(...args);
    }
  },
  PathItemElement: {
    get(...args) {
      return new OperationElement(...args);
    },
    put(...args) {
      return new OperationElement(...args);
    },
    post(...args) {
      return new OperationElement(...args);
    },
    delete(...args) {
      return new OperationElement(...args);
    },
    options(...args) {
      return new OperationElement(...args);
    },
    head(...args) {
      return new OperationElement(...args);
    },
    patch(...args) {
      return new OperationElement(...args);
    },
    trace(...args) {
      return new OperationElement(...args);
    },
    servers(...args) {
      return new PathItemServersElement(...args);
    },
    parameters(...args) {
      return new PathItemParametersElement(...args);
    }
  },
  OperationElement: {
    tags(...args) {
      return new OperationTagsElement(...args);
    },
    externalDocs(...args) {
      return new ExternalDocumentationElement(...args);
    },
    parameters(...args) {
      return new OperationParametersElement(...args);
    },
    requestBody(...args) {
      return new RequestBodyElement(...args);
    },
    responses(...args) {
      return new ResponsesElement(...args);
    },
    callbacks(...args) {
      return new OperationCallbacksElement(...args);
    },
    security(...args) {
      return new OperationSecurityElement(...args);
    },
    servers(...args) {
      return new OperationServersElement(...args);
    }
  },
  ParameterElement: {
    schema(...args) {
      return new SchemaElement(...args);
    },
    examples(...args) {
      return new ParameterExamplesElement(...args);
    },
    content(...args) {
      return new ParameterContentElement(...args);
    }
  },
  RequestBodyElement: {
    content(...args) {
      return new RequestBodyContentElement(...args);
    }
  },
  MediaTypeElement: {
    schema(...args) {
      return new SchemaElement(...args);
    },
    examples(...args) {
      return new MediaTypeExamplesElement(...args);
    },
    encoding(...args) {
      return new MediaTypeEncodingElement(...args);
    }
  },
  EncodingElement: {
    headers(...args) {
      return new EncodingHeadersElement(...args);
    }
  },
  ResponsesElement: {
    '[key: *]': function key(...args) {
      return new ResponseElement(...args);
    }
  },
  ResponseElement: {
    headers(...args) {
      return new ResponseHeadersElement(...args);
    },
    content(...args) {
      return new ResponseContentElement(...args);
    },
    links(...args) {
      return new ResponseLinksElement(...args);
    }
  },
  CallbackElement: {
    '[key: *]': function key(...args) {
      return new PathItemElement(...args);
    }
  },
  LinkElement: {
    parameters(...args) {
      return new LinkParametersElement(...args);
    },
    server(...args) {
      return new ServerElement(...args);
    }
  },
  HeaderElement: {
    schema(...args) {
      return new SchemaElement(...args);
    },
    examples(...args) {
      return new HeaderExamplesElement(...args);
    },
    content(...args) {
      return new HeaderContentElement(...args);
    }
  },
  ComponentsElement: {
    schemas(...args) {
      return new ComponentsSchemasElement(...args);
    },
    responses(...args) {
      return new ComponentsResponsesElement(...args);
    },
    parameters(...args) {
      return new ComponentsParametersElement(...args);
    },
    examples(...args) {
      return new ComponentsExamplesElement(...args);
    },
    requestBodies(...args) {
      return new ComponentsRequestBodiesElement(...args);
    },
    headers(...args) {
      return new ComponentsHeadersElement(...args);
    },
    securitySchemes(...args) {
      return new ComponentsSecuritySchemesElement(...args);
    },
    links(...args) {
      return new ComponentsLinksElement(...args);
    },
    callbacks(...args) {
      return new ComponentsCallbacksElement(...args);
    }
  },
  SecurityRequirementElement: {
    '[key: *]': function key(...args) {
      return new ArrayElement(...args);
    }
  },
  TagElement: {
    externalDocs(...args) {
      return new ExternalDocumentationElement(...args);
    }
  },
  SchemaElement: {
    definitions(...args) {
      const element = new ObjectElement(...args);
      element.classes.push('json-schema-definitions');
      return element;
    },
    allOf(...args) {
      const element = new ArrayElement(...args);
      element.classes.push('json-schema-allOf');
      return element;
    },
    anyOf(...args) {
      const element = new ArrayElement(...args);
      element.classes.push('json-schema-anyOf');
      return element;
    },
    oneOf(...args) {
      const element = new ArrayElement(...args);
      element.classes.push('json-schema-oneOf');
      return element;
    },
    not(...args) {
      return new SchemaElement(...args);
    },
    items(...args) {
      return new SchemaElement(...args);
    },
    properties(...args) {
      const element = new ObjectElement(...args);
      element.classes.push('json-schema-properties');
      return element;
    },
    patternProperties(...args) {
      const element = new ObjectElement(...args);
      element.classes.push('json-schema-patternProperties');
      return element;
    },
    additionalProperties(...args) {
      return new SchemaElement(...args);
    },
    enum(...args) {
      const element = new ArrayElement(...args);
      element.classes.push('json-schema-enum');
      return element;
    },
    required(...args) {
      const element = new ArrayElement(...args);
      element.classes.push('json-schema-required');
      return element;
    },
    discriminator(...args) {
      return new DiscriminatorElement(...args);
    },
    xml(...args) {
      return new XmlElement(...args);
    },
    externalDocs(...args) {
      return new ExternalDocumentationElement(...args);
    }
  },
  DiscriminatorElement: {
    mapping(...args) {
      return new DiscriminatorMappingElement(...args);
    }
  },
  SecuritySchemeElement: {
    flows(...args) {
      return new OAuthFlowsElement(...args);
    }
  },
  OAuthFlowsElement: {
    implicit(...args) {
      return new OAuthFlowElement(...args);
    },
    password(...args) {
      return new OAuthFlowElement(...args);
    },
    clientCredentials(...args) {
      return new OAuthFlowElement(...args);
    },
    authorizationCode(...args) {
      return new OAuthFlowElement(...args);
    }
  },
  OAuthFlowElement: {
    scopes(...args) {
      return new OAuthFlowScopesElement(...args);
    }
  },
  // non-concrete types handling (NCEs)
  [ServerVariablesElement.primaryClass]: {
    '[key: *]': function key(...args) {
      return new ServerVariableElement(...args);
    }
  },
  [ComponentsSchemasElement.primaryClass]: {
    '[key: *]': function key(...args) {
      return new SchemaElement(...args);
    }
  },
  [ComponentsResponsesElement.primaryClass]: {
    '[key: *]': function key(...args) {
      return new ResponseElement(...args);
    }
  },
  [ComponentsParametersElement.primaryClass]: {
    '[key: *]': function key(...args) {
      return new ParameterElement(...args);
    }
  },
  [ComponentsExamplesElement.primaryClass]: {
    '[key: *]': function key(...args) {
      return new ExampleElement(...args);
    }
  },
  [ComponentsRequestBodiesElement.primaryClass]: {
    '[key: *]': function key(...args) {
      return new RequestBodyElement(...args);
    }
  },
  [ComponentsHeadersElement.primaryClass]: {
    '[key: *]': function key(...args) {
      return new HeaderElement(...args);
    }
  },
  [ComponentsSecuritySchemesElement.primaryClass]: {
    '[key: *]': function key(...args) {
      return new SecuritySchemeElement(...args);
    }
  },
  [ComponentsLinksElement.primaryClass]: {
    '[key: *]': function key(...args) {
      return new LinkElement(...args);
    }
  },
  [ComponentsCallbacksElement.primaryClass]: {
    '[key: *]': function key(...args) {
      return new CallbackElement(...args);
    }
  },
  [OperationCallbacksElement.primaryClass]: {
    '[key: *]': function key(...args) {
      return new CallbackElement(...args);
    }
  },
  [ParameterExamplesElement.primaryClass]: {
    '[key: *]': function key(...args) {
      return new ExampleElement(...args);
    }
  },
  [ParameterContentElement.primaryClass]: {
    '[key: *]': function key(...args) {
      return new MediaTypeElement(...args);
    }
  },
  [RequestBodyContentElement.primaryClass]: {
    '[key: *]': function key(...args) {
      return new MediaTypeElement(...args);
    }
  },
  [MediaTypeExamplesElement.primaryClass]: {
    '[key: *]': function key(...args) {
      return new ExampleElement(...args);
    }
  },
  [MediaTypeEncodingElement.primaryClass]: {
    '[key: *]': function key(...args) {
      return new EncodingElement(...args);
    }
  },
  [EncodingHeadersElement.primaryClass]: {
    '[key: *]': function key(...args) {
      return new HeaderElement(...args);
    }
  },
  [ResponseHeadersElement.primaryClass]: {
    '[key: *]': function key(...args) {
      return new HeaderElement(...args);
    }
  },
  [ResponseContentElement.primaryClass]: {
    '[key: *]': function key(...args) {
      return new MediaTypeElement(...args);
    }
  },
  [ResponseLinksElement.primaryClass]: {
    '[key: *]': function key(...args) {
      return new LinkElement(...args);
    }
  },
  'json-schema-$defs': {
    '[key: *]': function key(...args) {
      return new SchemaElement(...args);
    }
  },
  'json-schema-dependentSchemas': {
    '[key: *]': function key(...args) {
      return new SchemaElement(...args);
    }
  },
  'json-schema-properties': {
    '[key: *]': function key(...args) {
      return new SchemaElement(...args);
    }
  },
  [ServersElement.primaryClass]: {
    '<*>': function asterisk(...args) {
      return new ServerElement(...args);
    }
  },
  [SecurityElement.primaryClass]: {
    '<*>': function asterisk(...args) {
      return new SecurityRequirementElement(...args);
    }
  },
  [TagsElement.primaryClass]: {
    '<*>': function asterisk(...args) {
      return new TagElement(...args);
    }
  },
  [PathItemServersElement.primaryClass]: {
    '<*>': function asterisk(...args) {
      return new ServerElement(...args);
    }
  },
  [PathItemParametersElement.primaryClass]: {
    '<*>': function asterisk(...args) {
      return new ParameterElement(...args);
    }
  },
  [OperationParametersElement.primaryClass]: {
    '<*>': function asterisk(...args) {
      return new ParameterElement(...args);
    }
  },
  [OperationSecurityElement.primaryClass]: {
    '<*>': function asterisk(...args) {
      return new SecurityRequirementElement(...args);
    }
  },
  [OperationServersElement.primaryClass]: {
    '<*>': function asterisk(...args) {
      return new ServerElement(...args);
    }
  },
  'json-schema-allOf': {
    '<*>': function asterisk(...args) {
      return new SchemaElement(...args);
    }
  },
  'json-schema-anyOf': {
    '<*>': function asterisk(...args) {
      return new SchemaElement(...args);
    }
  },
  'json-schema-oneOf': {
    '<*>': function asterisk(...args) {
      return new SchemaElement(...args);
    }
  },
  'json-schema-prefixItems': {
    '<*>': function asterisk(...args) {
      return new SchemaElement(...args);
    }
  }
};
const findElementFactory = (ancestor, keyName) => {
  var _ancestor$classes$fir, _ancestor$classes$fir2;
  const elementType = getNodeType(ancestor); // @ts-ignore
  const keyMapping = schema[elementType] || schema[(_ancestor$classes$fir = ancestor.classes.first) === null || _ancestor$classes$fir === void 0 || (_ancestor$classes$fir2 = _ancestor$classes$fir.toValue) === null || _ancestor$classes$fir2 === void 0 ? void 0 : _ancestor$classes$fir2.call(_ancestor$classes$fir)];
  return typeof keyMapping === 'undefined' ? undefined : Object.prototype.hasOwnProperty.call(keyMapping, '[key: *]') ? keyMapping['[key: *]'] : keyMapping[keyName];
};
const plugin = () => () => {
  return {
    visitor: {
      MemberElement(element, ...rest) {
        // no empty Element, continue with next one
        if (!isEmptyElement(element.value)) return undefined;
        const [,,, ancestors] = rest;
        const ancestor = ancestors[ancestors.length - 1]; // @ts-ignore
        const elementFactory = findElementFactory(ancestor, element.key.toValue());

        // no element factory found
        if (typeof elementFactory === 'undefined') return undefined;
        const originalValue = element.value;
        return new MemberElement(element.key, elementFactory.call({
          context: ancestor
        }, undefined, originalValue.meta.clone(), originalValue.attributes.clone()), element.meta.clone(), element.attributes.clone());
      },
      StringElement(element, ...rest) {
        if (!isEmptyElement(element)) return undefined;
        const [,,, ancestors] = rest;
        const ancestor = ancestors[ancestors.length - 1];

        // we're only interested in empty elements in ArrayElements
        if (!isArrayElement(ancestor)) return undefined;
        const elementFactory = findElementFactory(ancestor, '<*>');

        // no element factory found
        if (typeof elementFactory === 'undefined') return undefined;
        return elementFactory.call({
          context: element
        }, undefined, element.meta.clone(), element.attributes.clone());
      }
    }
  };
};
export default plugin;