import stampit from 'stampit';
import { always } from 'ramda';
import { ObjectElement } from '@swagger-api/apidom-core';
import MapVisitor from "../generics/MapVisitor.js";
import FallbackVisitor from "../FallbackVisitor.js";
const ContentVisitor = stampit(MapVisitor, FallbackVisitor, {
  props: {
    specPath: always(['document', 'objects', 'MediaType'])
  },
  init() {
    this.element = new ObjectElement();
    this.element.classes.push('content');
  }
});
export default ContentVisitor;