import stampit from 'stampit';
import { isReferenceLikeElement } from "../../../predicates.js";
import { isReferenceElement } from "../../../../predicates.js";
import OperationCallbacksElement from "../../../../elements/nces/OperationCallbacks.js";
import MapVisitor from "../../generics/MapVisitor.js";
import FallbackVisitor from "../../FallbackVisitor.js";
const CallbacksVisitor = stampit(MapVisitor, FallbackVisitor, {
  props: {
    specPath: element => isReferenceLikeElement(element) ? ['document', 'objects', 'Reference'] : ['document', 'objects', 'Callback']
  },
  init() {
    this.element = new OperationCallbacksElement();
  },
  methods: {
    ObjectElement(objectElement) {
      // @ts-ignore
      const result = MapVisitor.compose.methods.ObjectElement.call(this, objectElement);
      this.element.filter(isReferenceElement).forEach(referenceElement => {
        referenceElement.setMetaProperty('referenced-element', 'callback');
      });
      return result;
    }
  }
});
export default CallbacksVisitor;