import stampit from 'stampit';
import { T as stubTrue } from 'ramda';
import { isReferenceElement } from "../../../../predicates.js";
import { isReferenceLikeElement } from "../../../predicates.js";
import AlternatingVisitor from "../../generics/AlternatingVisitor.js";
const RequestBodyVisitor = stampit(AlternatingVisitor, {
  props: {
    alternator: [{
      predicate: isReferenceLikeElement,
      specPath: ['document', 'objects', 'Reference']
    }, {
      predicate: stubTrue,
      specPath: ['document', 'objects', 'RequestBody']
    }]
  },
  methods: {
    ObjectElement(objectElement) {
      // @ts-ignore
      const result = AlternatingVisitor.compose.methods.enter.call(this, objectElement);
      if (isReferenceElement(this.element)) {
        this.element.setMetaProperty('referenced-element', 'requestBody');
      }
      return result;
    }
  }
});
export default RequestBodyVisitor;