import stampit from 'stampit';
import { always } from 'ramda';
import { isObjectElement } from '@swagger-api/apidom-core';
import ParameterElement from "../../../../elements/Parameter.js";
import FixedFieldsVisitor from "../../generics/FixedFieldsVisitor.js";
import FallbackVisitor from "../../FallbackVisitor.js";
import { isMediaTypeElement } from "../../../../predicates.js";
const ParameterVisitor = stampit(FixedFieldsVisitor, FallbackVisitor, {
  props: {
    specPath: always(['document', 'objects', 'Parameter']),
    canSupportSpecificationExtensions: true
  },
  init() {
    this.element = new ParameterElement();
  },
  methods: {
    ObjectElement(objectElement) {
      // @ts-ignore
      const result = FixedFieldsVisitor.compose.methods.ObjectElement.call(this, objectElement);

      // decorate every MediaTypeElement with media type metadata
      if (isObjectElement(this.element.contentProp)) {
        this.element.contentProp.filter(isMediaTypeElement).forEach((mediaTypeElement, key) => {
          mediaTypeElement.setMetaProperty('media-type', key.toValue());
        });
      }
      return result;
    }
  }
});
export default ParameterVisitor;