import stampit from 'stampit';
import { always } from 'ramda';
import { isStringElement } from '@swagger-api/apidom-core';
import ReferenceElement from "../../../../elements/Reference.js";
import FixedFieldsVisitor from "../../generics/FixedFieldsVisitor.js";
import FallbackVisitor from "../../FallbackVisitor.js";
const ReferenceVisitor = stampit(FixedFieldsVisitor, FallbackVisitor, {
  props: {
    specPath: always(['document', 'objects', 'Reference']),
    canSupportSpecificationExtensions: false
  },
  init() {
    this.element = new ReferenceElement();
  },
  methods: {
    ObjectElement(objectElement) {
      // @ts-ignore
      const result = FixedFieldsVisitor.compose.methods.ObjectElement.call(this, objectElement);

      // mark this ReferenceElement with reference metadata
      if (isStringElement(this.element.$ref)) {
        this.element.classes.push('reference-element');
      }
      return result;
    }
  }
});
export default ReferenceVisitor;