import stampit from 'stampit';
import { always } from 'ramda';
import { isObjectElement } from '@swagger-api/apidom-core';
import RequestBodyElement from "../../../../elements/RequestBody.js";
import FixedFieldsVisitor from "../../generics/FixedFieldsVisitor.js";
import FallbackVisitor from "../../FallbackVisitor.js";
import { isMediaTypeElement } from "../../../../predicates.js";
const RequestBodyVisitor = stampit(FixedFieldsVisitor, FallbackVisitor, {
  props: {
    specPath: always(['document', 'objects', 'RequestBody'])
  },
  init() {
    this.element = new RequestBodyElement();
  },
  methods: {
    ObjectElement(objectElement) {
      // @ts-ignore
      const result = FixedFieldsVisitor.compose.methods.ObjectElement.call(this, objectElement);

      // decorate every MediaTypeElement with media type metadata
      if (isObjectElement(this.element.contentProp)) {
        this.element.contentProp.filter(isMediaTypeElement).forEach((mediaTypeElement, key) => {
          mediaTypeElement.setMetaProperty('media-type', key.toValue());
        });
      }
      return result;
    }
  }
});
export default RequestBodyVisitor;