import stampit from 'stampit';
import ResponseLinksElement from "../../../../elements/nces/ResponseLinks.js";
import MapVisitor from "../../generics/MapVisitor.js";
import FallbackVisitor from "../../FallbackVisitor.js";
import { isReferenceLikeElement } from "../../../predicates.js";
import { isReferenceElement } from "../../../../predicates.js";
const HeadersVisitor = stampit(MapVisitor, FallbackVisitor, {
  props: {
    specPath: element => {
      // eslint-disable-next-line no-nested-ternary
      return isReferenceLikeElement(element) ? ['document', 'objects', 'Reference'] : ['document', 'objects', 'Link'];
    }
  },
  init() {
    this.element = new ResponseLinksElement();
  },
  methods: {
    ObjectElement(objectElement) {
      // @ts-ignore
      const result = MapVisitor.compose.methods.ObjectElement.call(this, objectElement);
      this.element.filter(isReferenceElement).forEach(referenceElement => {
        referenceElement.setMetaProperty('referenced-element', 'link');
      });
      return result;
    }
  }
});
export default HeadersVisitor;