import stampit from 'stampit';
import { specificationObj as JSONSchemaDraft4Specification } from '@swagger-api/apidom-ns-json-schema-draft-4';
import { isReferenceElement } from "../../../../predicates.js";
const {
  allOf: JSONSchemaAllOfVisitor
} = JSONSchemaDraft4Specification.visitors.document.objects.JSONSchema.fixedFields;
const AllOfVisitor = stampit(JSONSchemaAllOfVisitor, {
  methods: {
    ArrayElement(arrayElement) {
      // @ts-ignore
      const result = JSONSchemaAllOfVisitor.compose.methods.ArrayElement.call(this, arrayElement);
      this.element.filter(isReferenceElement).forEach(referenceElement => {
        referenceElement.setMetaProperty('referenced-element', 'schema');
      });
      return result;
    }
  }
});
export default AllOfVisitor;