"use strict";

var _interopRequireDefault = require("@babel/runtime-corejs3/helpers/interopRequireDefault");
exports.__esModule = true;
exports.default = void 0;
var _stampit = _interopRequireDefault(require("stampit"));
var _apidomCore = require("@swagger-api/apidom-core");
var _Visitor = _interopRequireDefault(require("./Visitor.cjs"));
/**
 * This visitor is responsible for falling back to current traversed element
 * Given OpenApi3_0Visitor expects ObjectElement to be traversed. If
 * different Element is provided FallBackVisitor is responsible to assigning
 * this Element as current element.
 */
const FallbackVisitor = (0, _stampit.default)(_Visitor.default, {
  methods: {
    enter(element) {
      this.element = element.clone();
      return _apidomCore.BREAK;
    }
  }
});
var _default = FallbackVisitor;
exports.default = _default;