"use strict";

var _interopRequireDefault = require("@babel/runtime-corejs3/helpers/interopRequireDefault");
exports.__esModule = true;
exports.default = void 0;
var _stampit = _interopRequireDefault(require("stampit"));
var _apidomCore = require("@swagger-api/apidom-core");
var _Tags = _interopRequireDefault(require("../../../elements/nces/Tags.cjs"));
var _SpecificationVisitor = _interopRequireDefault(require("../SpecificationVisitor.cjs"));
var _FallbackVisitor = _interopRequireDefault(require("../FallbackVisitor.cjs"));
var _predicates = require("../../predicates.cjs");
const TagsVisitor = (0, _stampit.default)(_SpecificationVisitor.default, _FallbackVisitor.default, {
  init() {
    this.element = new _Tags.default();
  },
  methods: {
    ArrayElement(arrayElement) {
      arrayElement.forEach(item => {
        const specPath = (0, _predicates.isTagLikeElement)(item) ? ['document', 'objects', 'Tag'] : ['value'];
        const element = this.toRefractedElement(specPath, item);
        this.element.push(element);
      });
      this.copyMetaAndAttributes(arrayElement, this.element);
      return _apidomCore.BREAK;
    }
  }
});
var _default = TagsVisitor;
exports.default = _default;