"use strict";

var _interopRequireDefault = require("@babel/runtime-corejs3/helpers/interopRequireDefault");
exports.__esModule = true;
exports.default = void 0;
var _stampit = _interopRequireDefault(require("stampit"));
var _ramda = require("ramda");
var _FixedFieldsVisitor = _interopRequireDefault(require("../generics/FixedFieldsVisitor.cjs"));
var _FallbackVisitor = _interopRequireDefault(require("../FallbackVisitor.cjs"));
var _OpenApi = _interopRequireDefault(require("../../../elements/OpenApi3-0.cjs"));
// eslint-disable-next-line @typescript-eslint/naming-convention
const OpenApi3_0Visitor = (0, _stampit.default)(_FixedFieldsVisitor.default, _FallbackVisitor.default, {
  props: {
    specPath: (0, _ramda.always)(['document', 'objects', 'OpenApi']),
    canSupportSpecificationExtensions: true
  },
  init() {
    this.element = new _OpenApi.default();
  },
  methods: {
    ObjectElement(objectElement) {
      this.unrefractedElement = objectElement;

      // @ts-ignore
      return _FixedFieldsVisitor.default.compose.methods.ObjectElement.call(this, objectElement);
    }
  }
});
var _default = OpenApi3_0Visitor;
exports.default = _default;