"use strict";

var _interopRequireDefault = require("@babel/runtime-corejs3/helpers/interopRequireDefault");
exports.__esModule = true;
exports.default = void 0;
var _stampit = _interopRequireDefault(require("stampit"));
var _ramda = require("ramda");
var _apidomCore = require("@swagger-api/apidom-core");
var _Link = _interopRequireDefault(require("../../../../elements/Link.cjs"));
var _FallbackVisitor = _interopRequireDefault(require("../../FallbackVisitor.cjs"));
var _FixedFieldsVisitor = _interopRequireDefault(require("../../generics/FixedFieldsVisitor.cjs"));
const LinkVisitor = (0, _stampit.default)(_FixedFieldsVisitor.default, _FallbackVisitor.default, {
  props: {
    specPath: (0, _ramda.always)(['document', 'objects', 'Link']),
    canSupportSpecificationExtensions: true
  },
  init() {
    this.element = new _Link.default();
  },
  methods: {
    ObjectElement(objectElement) {
      // @ts-ignore
      const result = _FixedFieldsVisitor.default.compose.methods.ObjectElement.call(this, objectElement);

      // mark this LinkElement with reference metadata
      if ((0, _apidomCore.isStringElement)(this.element.operationId) || (0, _apidomCore.isStringElement)(this.element.operationRef)) {
        this.element.classes.push('reference-element');
      }
      return result;
    }
  }
});
var _default = LinkVisitor;
exports.default = _default;