"use strict";

var _interopRequireDefault = require("@babel/runtime-corejs3/helpers/interopRequireDefault");
exports.__esModule = true;
exports.default = void 0;
var _stampit = _interopRequireDefault(require("stampit"));
var _ramda = require("ramda");
var _predicates = require("../../../../predicates.cjs");
var _predicates2 = require("../../../predicates.cjs");
var _AlternatingVisitor = _interopRequireDefault(require("../../generics/AlternatingVisitor.cjs"));
const RequestBodyVisitor = (0, _stampit.default)(_AlternatingVisitor.default, {
  props: {
    alternator: [{
      predicate: _predicates2.isReferenceLikeElement,
      specPath: ['document', 'objects', 'Reference']
    }, {
      predicate: _ramda.T,
      specPath: ['document', 'objects', 'RequestBody']
    }]
  },
  methods: {
    ObjectElement(objectElement) {
      // @ts-ignore
      const result = _AlternatingVisitor.default.compose.methods.enter.call(this, objectElement);
      if ((0, _predicates.isReferenceElement)(this.element)) {
        this.element.setMetaProperty('referenced-element', 'requestBody');
      }
      return result;
    }
  }
});
var _default = RequestBodyVisitor;
exports.default = _default;