import _defineProperty from "@babel/runtime-corejs3/helpers/esm/defineProperty";
function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); enumerableOnly && (symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; })), keys.push.apply(keys, symbols); } return keys; }
function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = null != arguments[i] ? arguments[i] : {}; i % 2 ? ownKeys(Object(source), !0).forEach(function (key) { _defineProperty(target, key, source[key]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } return target; }
import stampit from 'stampit';
import { pathSatisfies, path, pick, pipe, keys } from 'ramda';
import { isFunction, isUndefined } from 'ramda-adjunct';
import { visit } from '@swagger-api/apidom-core';
import Visitor from "./Visitor.js";
import { keyMap, getNodeType } from "../../traversal/visitor.js";
/**
 * This is a base Type for every visitor that does
 * internal look-ups to retrieve other child visitors.
 */
const SpecificationVisitor = stampit(Visitor, {
  props: {
    passingOptionsNames: ['specObj', 'openApiGenericElement', 'openApiSemanticElement'],
    specObj: null,
    openApiGenericElement: null,
    openApiSemanticElement: null
  },
  init({
    // @ts-ignore
    specObj = this.specObj,
    // @ts-ignore
    openApiGenericElement = this.openApiGenericElement,
    // @ts-ignore
    openApiSemanticElement = this.openApiSemanticElement
  }) {
    this.specObj = specObj;
    this.openApiGenericElement = openApiGenericElement;
    this.openApiSemanticElement = openApiSemanticElement;
  },
  methods: {
    retrievePassingOptions() {
      return pick(this.passingOptionsNames, this);
    },
    retrieveFixedFields(specPath) {
      return pipe(path(['visitors', ...specPath, 'fixedFields']), keys)(this.specObj);
    },
    retrieveVisitor(specPath) {
      if (pathSatisfies(isFunction, ['visitors', ...specPath], this.specObj)) {
        return path(['visitors', ...specPath], this.specObj);
      }
      return path(['visitors', ...specPath, '$visitor'], this.specObj);
    },
    retrieveVisitorInstance(specPath, options = {}) {
      const passingOpts = this.retrievePassingOptions();
      return this.retrieveVisitor(specPath)(_objectSpread(_objectSpread({}, passingOpts), options));
    },
    toRefractedElement(specPath, element, options = {}) {
      /**
       * This is `Visitor shortcut`: mechanism for short circuiting the traversal and replacing
       * it by basic node cloning.
       *
       * Visiting the element is equivalent to cloning it  if the prototype of a visitor
       * is the same as the prototype of FallbackVisitor. If that's the case, we can avoid
       * bootstrapping the traversal cycle for fields that don't require any special visiting.
       */
      const visitor = this.retrieveVisitorInstance(specPath, options);
      const visitorPrototype = Object.getPrototypeOf(visitor);
      if (isUndefined(this.fallbackVisitorPrototype)) {
        this.fallbackVisitorPrototype = Object.getPrototypeOf(this.retrieveVisitorInstance(['value']));
      }
      if (this.fallbackVisitorPrototype === visitorPrototype) {
        return element.clone();
      }

      // standard processing continues
      visit(element, visitor, _objectSpread({
        keyMap,
        nodeTypeGetter: getNodeType
      }, options));
      return visitor.element;
    }
  }
});
export default SpecificationVisitor;