import stampit from 'stampit';
import { test, always } from 'ramda';
import CallbackElement from "../../../../elements/Callback.js";
import PatternedFieldsVisitor from "../../generics/PatternedFieldsVisitor.js";
import FallbackVisitor from "../../FallbackVisitor.js";
import MapVisitor from "../../generics/MapVisitor.js";
import { isPathItemElement } from "../../../../predicates.js";
const CallbackVisitor = stampit(PatternedFieldsVisitor, FallbackVisitor, {
  props: {
    fieldPatternPredicate: test(/{(?<expression>.*)}/),
    specPath: always(['document', 'objects', 'PathItem']),
    canSupportSpecificationExtensions: true
  },
  init() {
    this.element = new CallbackElement();
  },
  methods: {
    ObjectElement(objectElement) {
      // @ts-ignore
      const result = MapVisitor.compose.methods.ObjectElement.call(this, objectElement);

      // decorate every PathItemElement with Callback Object expression metadata
      this.element.filter(isPathItemElement).forEach((pathItemElement, key) => {
        pathItemElement.setMetaProperty('runtime-expression', key.toValue());
      });
      return result;
    }
  }
});
export default CallbackVisitor;