import stampit from 'stampit';
import { always } from 'ramda';
import { isObjectElement } from '@swagger-api/apidom-core';
import EncodingElement from "../../../../elements/Encoding.js";
import FallbackVisitor from "../../FallbackVisitor.js";
import FixedFieldsVisitor from "../../generics/FixedFieldsVisitor.js";
import { isHeaderElement } from "../../../../predicates.js";
const EncodingVisitor = stampit(FixedFieldsVisitor, FallbackVisitor, {
  props: {
    specPath: always(['document', 'objects', 'Encoding']),
    canSupportSpecificationExtensions: true
  },
  init() {
    this.element = new EncodingElement();
  },
  methods: {
    ObjectElement(objectElement) {
      // @ts-ignore
      const result = FixedFieldsVisitor.compose.methods.ObjectElement.call(this, objectElement);

      // decorate every Header with media type metadata
      if (isObjectElement(this.element.headers)) {
        this.element.headers.filter(isHeaderElement).forEach((headerElement, key) => {
          headerElement.setMetaProperty('header-name', key.toValue());
        });
      }
      return result;
    }
  }
});
export default EncodingVisitor;