import stampit from 'stampit';
import { isObjectElement, BREAK } from '@swagger-api/apidom-core';
import OperationSecurityElement from "../../../../elements/nces/OperationSecurity.js";
import SpecificationVisitor from "../../SpecificationVisitor.js";
import FallbackVisitor from "../../FallbackVisitor.js";
const SecurityVisitor = stampit(SpecificationVisitor, FallbackVisitor, {
  init() {
    this.element = new OperationSecurityElement();
  },
  methods: {
    ArrayElement(arrayElement) {
      arrayElement.forEach(item => {
        const specPath = isObjectElement(item) ? ['document', 'objects', 'SecurityRequirement'] : ['value'];
        const element = this.toRefractedElement(specPath, item);
        this.element.push(element);
      });
      this.copyMetaAndAttributes(arrayElement, this.element);
      return BREAK;
    }
  }
});
export default SecurityVisitor;