import stampit from 'stampit';
import ResponseHeadersElement from "../../../../elements/nces/ResponseHeaders.js";
import MapVisitor from "../../generics/MapVisitor.js";
import FallbackVisitor from "../../FallbackVisitor.js";
import { isReferenceLikeElement } from "../../../predicates.js";
import { isHeaderElement, isReferenceElement } from "../../../../predicates.js";
const HeadersVisitor = stampit(MapVisitor, FallbackVisitor, {
  props: {
    specPath: element => {
      // eslint-disable-next-line no-nested-ternary
      return isReferenceLikeElement(element) ? ['document', 'objects', 'Reference'] : ['document', 'objects', 'Header'];
    }
  },
  init() {
    this.element = new ResponseHeadersElement();
  },
  methods: {
    ObjectElement(objectElement) {
      // @ts-ignore
      const result = MapVisitor.compose.methods.ObjectElement.call(this, objectElement);

      // decorate every ReferenceElement with metadata about their referencing type
      this.element.filter(isReferenceElement).forEach(referenceElement => {
        referenceElement.setMetaProperty('referenced-element', 'header');
      });

      // decorate every HeaderElement with metadata about their name
      this.element.forEach((value, key) => {
        if (!isHeaderElement(value)) return;
        const headerName = key.toValue();
        value.setMetaProperty('header-name', headerName);
      });
      return result;
    }
  }
});
export default HeadersVisitor;