import stampit from 'stampit';
import { test, always, range } from 'ramda';
import ResponsesElement from "../../../../elements/Responses.js";
import MixedFieldsVisitor from "../../generics/MixedFieldsVisitor.js";
import FallbackVisitor from "../../FallbackVisitor.js";
import { isReferenceLikeElement } from "../../../predicates.js";
import { isReferenceElement, isResponseElement } from "../../../../predicates.js";
const ResponsesVisitor = stampit(MixedFieldsVisitor, FallbackVisitor, {
  props: {
    specPathFixedFields: always(['document', 'objects', 'Responses']),
    specPathPatternedFields: element => {
      return isReferenceLikeElement(element) ? ['document', 'objects', 'Reference'] : ['document', 'objects', 'Response'];
    },
    fieldPatternPredicate: test(new RegExp(`^(1XX|2XX|3XX|4XX|5XX|${range(100, 600).join('|')})$`)),
    canSupportSpecificationExtensions: true
  },
  init() {
    this.element = new ResponsesElement();
  },
  methods: {
    ObjectElement(objectElement) {
      // @ts-ignore
      const result = MixedFieldsVisitor.compose.methods.ObjectElement.call(this, objectElement);

      // decorate every ReferenceElement with metadata about their referencing type
      this.element.filter(isReferenceElement).forEach(referenceElement => {
        referenceElement.setMetaProperty('referenced-element', 'response');
      });

      // decorate every ResponseElement with metadata about their status code
      this.element.filter(isResponseElement).forEach((value, key) => {
        const httpStatusCode = key.clone();
        if (!this.fieldPatternPredicate(httpStatusCode.toValue())) return;
        value.setMetaProperty('http-status-code', httpStatusCode);
      });
      return result;
    }
  }
});
export default ResponsesVisitor;