import stampit from 'stampit';
import { specificationObj as JSONSchemaDraft4Specification } from '@swagger-api/apidom-ns-json-schema-draft-4';
import { isReferenceElement } from "../../../../predicates.js";
const {
  definitions: JSONSchemaDefinitionsVisitor
} = JSONSchemaDraft4Specification.visitors.document.objects.JSONSchema.fixedFields;
const DefinitionsVisitor = stampit(JSONSchemaDefinitionsVisitor, {
  methods: {
    ObjectElement(objectElement) {
      // @ts-ignore
      const result = JSONSchemaDefinitionsVisitor.compose.methods.ObjectElement.call(this, objectElement);
      this.element.filter(isReferenceElement).forEach(referenceElement => {
        referenceElement.setMetaProperty('referenced-element', 'schema');
      });
      return result;
    }
  }
});
export default DefinitionsVisitor;