import stampit from 'stampit';
import { specificationObj as JSONSchemaDraft4Specification } from '@swagger-api/apidom-ns-json-schema-draft-4';
import { isReferenceElement } from "../../../../predicates.js";
const {
  oneOf: JSONSchemaOneOfVisitor
} = JSONSchemaDraft4Specification.visitors.document.objects.JSONSchema.fixedFields;
const OneOfVisitor = stampit(JSONSchemaOneOfVisitor, {
  methods: {
    ArrayElement(arrayElement) {
      // @ts-ignore
      const result = JSONSchemaOneOfVisitor.compose.methods.ArrayElement.call(this, arrayElement);
      this.element.filter(isReferenceElement).forEach(referenceElement => {
        referenceElement.setMetaProperty('referenced-element', 'schema');
      });
      return result;
    }
  }
});
export default OneOfVisitor;