/// <reference types="@swagger-api/apidom-core/types/minim" />
import { MediaTypes, NamespacePluginOptions, MemberElement, StringElement, Element, ObjectElement, Meta, Attributes, BooleanElement, ArrayElement } from '@swagger-api/apidom-core';
export { isArrayElement, isBooleanElement, isElement, isLinkElement as isLinkPrimitiveElement, isMemberElement, isNullElement, isNumberElement, isObjectElement, isRefElement, isStringElement } from '@swagger-api/apidom-core';
import * as minim from 'minim';
import * as stampit from 'stampit';
import stampit__default from 'stampit';
import { JSONSchemaElement } from '@swagger-api/apidom-ns-json-schema-draft-4';

type Format = 'generic' | 'json' | 'yaml';
declare class OpenAPIMediaTypes extends MediaTypes<string> {
    filterByFormat(format?: Format): string[];
    findBy(version?: string, format?: Format): string;
    latest(format?: Format): string;
}
declare const mediaTypes: OpenAPIMediaTypes;

declare const openApi3_0: {
    namespace: (options: NamespacePluginOptions) => minim.Namespace;
};

declare const plugin: () => () => {
    visitor: {
        MemberElement(element: MemberElement, ...rest: any): MemberElement | undefined;
        StringElement(element: StringElement, ...rest: any): any;
    };
};

declare const refract: <T extends Element>(value: any, { specPath, plugins }?: {
    specPath?: string[] | undefined;
    plugins?: never[] | undefined;
}) => T;
declare const createRefractor: (specPath: string[]) => (value: any, options?: {}) => Element;

declare const specification: {
    visitors: {
        value: stampit.default.Stamp<any>;
        document: {
            objects: {
                OpenApi: {
                    $visitor: stampit.default.Stamp<any>;
                    fixedFields: {
                        openapi: stampit.default.Stamp<any>;
                        info: {
                            $ref: string;
                        };
                        servers: stampit.default.Stamp<any>;
                        paths: {
                            $ref: string;
                        };
                        components: {
                            $ref: string;
                        };
                        security: stampit.default.Stamp<any>;
                        tags: stampit.default.Stamp<any>;
                        externalDocs: {
                            $ref: string;
                        };
                    };
                };
                Info: {
                    $visitor: stampit.default.Stamp<any>;
                    fixedFields: {
                        title: stampit.default.Stamp<any>;
                        description: stampit.default.Stamp<any>;
                        termsOfService: stampit.default.Stamp<any>;
                        contact: {
                            $ref: string;
                        };
                        license: {
                            $ref: string;
                        };
                        version: stampit.default.Stamp<any>;
                    };
                };
                Contact: {
                    $visitor: stampit.default.Stamp<any>;
                    fixedFields: {
                        name: stampit.default.Stamp<any>;
                        url: stampit.default.Stamp<any>;
                        email: stampit.default.Stamp<any>;
                    };
                };
                License: {
                    $visitor: stampit.default.Stamp<any>;
                    fixedFields: {
                        name: stampit.default.Stamp<any>;
                        url: stampit.default.Stamp<any>;
                    };
                };
                Server: {
                    $visitor: stampit.default.Stamp<any>;
                    fixedFields: {
                        url: stampit.default.Stamp<any>;
                        description: stampit.default.Stamp<any>;
                        variables: stampit.default.Stamp<any>;
                    };
                };
                ServerVariable: {
                    $visitor: stampit.default.Stamp<any>;
                    fixedFields: {
                        enum: stampit.default.Stamp<any>;
                        default: stampit.default.Stamp<any>;
                        description: stampit.default.Stamp<any>;
                    };
                };
                Components: {
                    $visitor: stampit.default.Stamp<any>;
                    fixedFields: {
                        schemas: stampit.default.Stamp<any>;
                        responses: stampit.default.Stamp<any>;
                        parameters: stampit.default.Stamp<any>;
                        examples: stampit.default.Stamp<any>;
                        requestBodies: stampit.default.Stamp<any>;
                        headers: stampit.default.Stamp<any>;
                        securitySchemes: stampit.default.Stamp<any>;
                        links: stampit.default.Stamp<any>;
                        callbacks: stampit.default.Stamp<any>;
                    };
                };
                Paths: {
                    $visitor: stampit.default.Stamp<any>;
                };
                PathItem: {
                    $visitor: stampit.default.Stamp<any>;
                    fixedFields: {
                        $ref: stampit.default.Stamp<any>;
                        summary: stampit.default.Stamp<any>;
                        description: stampit.default.Stamp<any>;
                        get: {
                            $ref: string;
                        };
                        put: {
                            $ref: string;
                        };
                        post: {
                            $ref: string;
                        };
                        delete: {
                            $ref: string;
                        };
                        options: {
                            $ref: string;
                        };
                        head: {
                            $ref: string;
                        };
                        patch: {
                            $ref: string;
                        };
                        trace: {
                            $ref: string;
                        };
                        servers: stampit.default.Stamp<any>;
                        parameters: stampit.default.Stamp<any>;
                    };
                };
                Operation: {
                    $visitor: stampit.default.Stamp<any>;
                    fixedFields: {
                        tags: stampit.default.Stamp<any>;
                        summary: stampit.default.Stamp<any>;
                        description: stampit.default.Stamp<any>;
                        externalDocs: {
                            $ref: string;
                        };
                        operationId: stampit.default.Stamp<any>;
                        parameters: stampit.default.Stamp<any>;
                        requestBody: stampit.default.Stamp<any>;
                        responses: {
                            $ref: string;
                        };
                        callbacks: stampit.default.Stamp<any>;
                        deprecated: stampit.default.Stamp<any>;
                        security: stampit.default.Stamp<any>;
                        servers: stampit.default.Stamp<any>;
                    };
                };
                ExternalDocumentation: {
                    $visitor: stampit.default.Stamp<any>;
                    fixedFields: {
                        description: stampit.default.Stamp<any>;
                        url: stampit.default.Stamp<any>;
                    };
                };
                Parameter: {
                    $visitor: stampit.default.Stamp<any>;
                    fixedFields: {
                        name: stampit.default.Stamp<any>;
                        in: stampit.default.Stamp<any>;
                        description: stampit.default.Stamp<any>;
                        required: stampit.default.Stamp<any>;
                        deprecated: stampit.default.Stamp<any>;
                        allowEmptyValue: stampit.default.Stamp<any>;
                        style: stampit.default.Stamp<any>;
                        explode: stampit.default.Stamp<any>;
                        allowReserved: stampit.default.Stamp<any>;
                        schema: stampit.default.Stamp<any>;
                        example: stampit.default.Stamp<any>;
                        examples: stampit.default.Stamp<any>;
                        content: stampit.default.Stamp<any>;
                    };
                };
                RequestBody: {
                    $visitor: stampit.default.Stamp<any>;
                    fixedFields: {
                        description: stampit.default.Stamp<any>;
                        content: stampit.default.Stamp<any>;
                        required: stampit.default.Stamp<any>;
                    };
                };
                MediaType: {
                    $visitor: stampit.default.Stamp<any>;
                    fixedFields: {
                        schema: stampit.default.Stamp<any>;
                        example: stampit.default.Stamp<any>;
                        examples: stampit.default.Stamp<any>;
                        encoding: stampit.default.Stamp<any>;
                    };
                };
                Encoding: {
                    $visitor: stampit.default.Stamp<any>;
                    fixedFields: {
                        contentType: stampit.default.Stamp<any>;
                        headers: stampit.default.Stamp<any>;
                        style: stampit.default.Stamp<any>;
                        explode: stampit.default.Stamp<any>;
                        allowReserved: stampit.default.Stamp<any>;
                    };
                };
                Responses: {
                    $visitor: stampit.default.Stamp<any>;
                    fixedFields: {
                        default: stampit.default.Stamp<any>;
                    };
                };
                Response: {
                    $visitor: stampit.default.Stamp<any>;
                    fixedFields: {
                        description: stampit.default.Stamp<any>;
                        headers: stampit.default.Stamp<any>;
                        content: stampit.default.Stamp<any>;
                        links: stampit.default.Stamp<any>;
                    };
                };
                Callback: {
                    $visitor: stampit.default.Stamp<any>;
                };
                Example: {
                    $visitor: stampit.default.Stamp<any>;
                    fixedFields: {
                        summary: stampit.default.Stamp<any>;
                        description: stampit.default.Stamp<any>;
                        value: stampit.default.Stamp<any>;
                        externalValue: stampit.default.Stamp<any>;
                    };
                };
                Link: {
                    $visitor: stampit.default.Stamp<any>;
                    fixedFields: {
                        operationRef: stampit.default.Stamp<any>;
                        operationId: stampit.default.Stamp<any>;
                        parameters: stampit.default.Stamp<any>;
                        requestBody: stampit.default.Stamp<any>;
                        description: stampit.default.Stamp<any>;
                        server: {
                            $ref: string;
                        };
                    };
                };
                Header: {
                    $visitor: stampit.default.Stamp<any>;
                    fixedFields: {
                        description: stampit.default.Stamp<any>;
                        required: stampit.default.Stamp<any>;
                        deprecated: stampit.default.Stamp<any>;
                        allowEmptyValue: stampit.default.Stamp<any>;
                        style: stampit.default.Stamp<any>;
                        explode: stampit.default.Stamp<any>;
                        allowReserved: stampit.default.Stamp<any>;
                        schema: stampit.default.Stamp<any>;
                        example: stampit.default.Stamp<any>;
                        examples: stampit.default.Stamp<any>;
                        content: stampit.default.Stamp<any>;
                    };
                };
                Tag: {
                    $visitor: stampit.default.Stamp<any>;
                    fixedFields: {
                        name: stampit.default.Stamp<any>;
                        description: stampit.default.Stamp<any>;
                        externalDocs: {
                            $ref: string;
                        };
                    };
                };
                JSONReference: {
                    $visitor: stampit.default.Stamp<any>;
                    fixedFields: {
                        $ref: stampit.default.Stamp<any>;
                    };
                };
                Reference: {
                    $visitor: stampit.default.Stamp<any>;
                    fixedFields: {
                        $ref: stampit.default.Stamp<any>;
                    };
                };
                JSONSchema: {
                    $visitor: stampit.default.Stamp<any>;
                    fixedFields: {
                        allOf: stampit.default.Stamp<any>;
                        anyOf: stampit.default.Stamp<any>;
                        oneOf: stampit.default.Stamp<any>;
                        definitions: stampit.default.Stamp<any>;
                        items: stampit.default.Stamp<any>;
                        dependencies: stampit.default.Stamp<any>;
                        properties: stampit.default.Stamp<any>;
                        patternProperties: stampit.default.Stamp<any>;
                        type: stampit.default.Stamp<any>;
                        nullable: stampit.default.Stamp<any>;
                        discriminator: {
                            $ref: string;
                        };
                        writeOnly: stampit.default.Stamp<any>;
                        xml: {
                            $ref: string;
                        };
                        externalDocs: {
                            $ref: string;
                        };
                        example: stampit.default.Stamp<any>;
                        deprecated: stampit.default.Stamp<any>;
                    };
                };
                Schema: {
                    $visitor: stampit.default.Stamp<any>;
                    fixedFields: {
                        allOf: stampit.default.Stamp<any>;
                        anyOf: stampit.default.Stamp<any>;
                        oneOf: stampit.default.Stamp<any>;
                        definitions: stampit.default.Stamp<any>;
                        items: stampit.default.Stamp<any>;
                        dependencies: stampit.default.Stamp<any>;
                        properties: stampit.default.Stamp<any>;
                        patternProperties: stampit.default.Stamp<any>;
                        type: stampit.default.Stamp<any>;
                        nullable: stampit.default.Stamp<any>;
                        discriminator: {
                            $ref: string;
                        };
                        writeOnly: stampit.default.Stamp<any>;
                        xml: {
                            $ref: string;
                        };
                        externalDocs: {
                            $ref: string;
                        };
                        example: stampit.default.Stamp<any>;
                        deprecated: stampit.default.Stamp<any>;
                    };
                };
                LinkDescription: {
                    $visitor: stampit.default.Stamp<any>;
                    fixedFields: {
                        href: stampit.default.Stamp<any>;
                        rel: stampit.default.Stamp<any>;
                        title: stampit.default.Stamp<any>;
                        targetSchema: stampit.default.Stamp<any>;
                        mediaType: stampit.default.Stamp<any>;
                        method: stampit.default.Stamp<any>;
                        encType: stampit.default.Stamp<any>;
                        schema: stampit.default.Stamp<any>;
                    };
                };
                Media: {
                    $visitor: stampit.default.Stamp<any>;
                    fixedFields: {
                        binaryEncoding: stampit.default.Stamp<any>;
                        type: stampit.default.Stamp<any>;
                    };
                };
                Discriminator: {
                    $visitor: stampit.default.Stamp<any>;
                    fixedFields: {
                        propertyName: stampit.default.Stamp<any>;
                        mapping: stampit.default.Stamp<any>;
                    };
                };
                XML: {
                    $visitor: stampit.default.Stamp<any>;
                    fixedFields: {
                        name: stampit.default.Stamp<any>;
                        namespace: stampit.default.Stamp<any>;
                        prefix: stampit.default.Stamp<any>;
                        attribute: stampit.default.Stamp<any>;
                        wrapped: stampit.default.Stamp<any>;
                    };
                };
                SecurityScheme: {
                    $visitor: stampit.default.Stamp<any>;
                    fixedFields: {
                        type: stampit.default.Stamp<any>;
                        description: stampit.default.Stamp<any>;
                        name: stampit.default.Stamp<any>;
                        in: stampit.default.Stamp<any>;
                        scheme: stampit.default.Stamp<any>;
                        bearerFormat: stampit.default.Stamp<any>;
                        flows: {
                            $ref: string;
                        };
                        openIdConnectUrl: stampit.default.Stamp<any>;
                    };
                };
                OAuthFlows: {
                    $visitor: stampit.default.Stamp<any>;
                    fixedFields: {
                        implicit: {
                            $ref: string;
                        };
                        password: {
                            $ref: string;
                        };
                        clientCredentials: {
                            $ref: string;
                        };
                        authorizationCode: {
                            $ref: string;
                        };
                    };
                };
                OAuthFlow: {
                    $visitor: stampit.default.Stamp<any>;
                    fixedFields: {
                        authorizationUrl: stampit.default.Stamp<any>;
                        tokenUrl: stampit.default.Stamp<any>;
                        refreshUrl: stampit.default.Stamp<any>;
                        scopes: stampit.default.Stamp<any>;
                    };
                };
                SecurityRequirement: {
                    $visitor: stampit.default.Stamp<any>;
                };
            };
            extension: {
                $visitor: stampit.default.Stamp<any>;
            };
        };
    };
};

declare class Server extends ObjectElement {
    constructor(content?: Record<string, unknown>, meta?: Meta, attributes?: Attributes);
    get url(): StringElement | undefined;
    set url(url: StringElement | undefined);
    get description(): StringElement | undefined;
    set description(description: StringElement | undefined);
    get variables(): ObjectElement | undefined;
    set variables(variables: ObjectElement | undefined);
}

declare class Reference extends ObjectElement {
    constructor(content?: Record<string, unknown>, meta?: Meta, attributes?: Attributes);
    get $ref(): StringElement | undefined;
    set $ref($ref: StringElement | undefined);
}

declare class ExternalDocumentation extends ObjectElement {
    constructor(content?: Record<string, unknown>, meta?: Meta, attributes?: Attributes);
    get description(): StringElement | undefined;
    set description(description: StringElement | undefined);
    get url(): StringElement | undefined;
    set url(url: StringElement | undefined);
}

declare class RequestBody extends ObjectElement {
    constructor(content?: Record<string, unknown>, meta?: Meta, attributes?: Attributes);
    get description(): StringElement | undefined;
    set description(description: StringElement | undefined);
    get contentProp(): ObjectElement | undefined;
    set contentProp(content: ObjectElement | undefined);
    get required(): BooleanElement;
    set required(required: BooleanElement);
}

declare class Response extends ObjectElement {
    constructor(content?: Record<string, unknown>, meta?: Meta, attributes?: Attributes);
    get description(): StringElement | undefined;
    set description(description: StringElement | undefined);
    get headers(): ObjectElement | undefined;
    set headers(headers: ObjectElement | undefined);
    get contentProp(): ObjectElement | undefined;
    set contentProp(contentProp: ObjectElement | undefined);
    get links(): ObjectElement | undefined;
    set links(links: ObjectElement | undefined);
}

declare class Responses extends ObjectElement {
    constructor(content?: Record<string, unknown>, meta?: Meta, attributes?: Attributes);
    get default(): Response | Reference | undefined;
    set default(defaultValue: Response | Reference | undefined);
}

declare class Operation extends ObjectElement {
    constructor(content?: Record<string, unknown>, meta?: Meta, attributes?: Attributes);
    get tags(): ArrayElement | undefined;
    set tags(tags: ArrayElement | undefined);
    get summary(): StringElement | undefined;
    set summary(description: StringElement | undefined);
    get description(): StringElement | undefined;
    set description(description: StringElement | undefined);
    set externalDocs(externalDocs: ExternalDocumentation | undefined);
    get externalDocs(): ExternalDocumentation | undefined;
    get operationId(): StringElement | undefined;
    set operationId(operationId: StringElement | undefined);
    get parameters(): ArrayElement | undefined;
    set parameters(parameters: ArrayElement | undefined);
    get requestBody(): RequestBody | Reference | undefined;
    set requestBody(requestBody: RequestBody | Reference | undefined);
    get responses(): Responses | undefined;
    set responses(responses: Responses | undefined);
    get callbacks(): ObjectElement | undefined;
    set callbacks(callbacks: ObjectElement | undefined);
    get deprecated(): BooleanElement;
    set deprecated(deprecated: BooleanElement);
    get security(): ArrayElement | undefined;
    set security(security: ArrayElement | undefined);
    get servers(): ArrayElement | undefined;
    set servers(servers: ArrayElement | undefined);
}

declare class Link extends ObjectElement {
    constructor(content?: Record<string, unknown>, meta?: Meta, attributes?: Attributes);
    get operationRef(): StringElement | undefined;
    set operationRef(operationRef: StringElement | undefined);
    get operationId(): StringElement | undefined;
    set operationId(operationId: StringElement | undefined);
    get operation(): Operation | undefined;
    set operation(operation: Operation | undefined);
    get parameters(): ObjectElement | undefined;
    set parameters(parameters: ObjectElement | undefined);
    get requestBody(): Element | undefined;
    set requestBody(requestBody: Element | undefined);
    get description(): StringElement | undefined;
    set description(description: StringElement | undefined);
    get server(): Server | undefined;
    set server(server: Server | undefined);
}

declare class PathItem extends ObjectElement {
    constructor(content?: Record<string, unknown>, meta?: Meta, attributes?: Attributes);
    get $ref(): StringElement | undefined;
    set $ref($ref: StringElement | undefined);
    get summary(): StringElement | undefined;
    set summary(summary: StringElement | undefined);
    get description(): StringElement;
    set description(description: StringElement | undefined);
    get GET(): Operation;
    set GET(operation: Operation | undefined);
    get PUT(): Operation;
    set PUT(operation: Operation | undefined);
    get POST(): Operation;
    set POST(operation: Operation | undefined);
    get DELETE(): Operation;
    set DELETE(operation: Operation | undefined);
    get OPTIONS(): Operation;
    set OPTIONS(operation: Operation | undefined);
    get HEAD(): Operation;
    set HEAD(operation: Operation | undefined);
    get PATCH(): Operation;
    set PATCH(operation: Operation | undefined);
    get TRACE(): Operation;
    set TRACE(operation: Operation | undefined);
    get servers(): ArrayElement | undefined;
    set servers(servers: ArrayElement | undefined);
    get parameters(): ArrayElement;
    set parameters(parameters: ArrayElement | undefined);
}

declare const isCallbackElement: (element: any) => boolean;
declare const isComponentsElement: (element: any) => boolean;
declare const isContactElement: (element: any) => boolean;
declare const isExampleElement: (element: any) => boolean;
declare const isExternalDocumentationElement: (element: any) => boolean;
declare const isInfoElement: (element: any) => boolean;
declare const isLicenseElement: (element: any) => boolean;
declare const isLinkElement: (element: any) => boolean;
declare const isLinkElementExternal: (element: any) => element is Link;
declare const isOpenapiElement: (element: any) => boolean;
declare const isOpenApi3_0Element: (element: any) => boolean;
declare const isOperationElement: (element: any) => boolean;
declare const isParameterElement: (element: any) => boolean;
declare const isPathItemElement: (element: any) => boolean;
declare const isPathItemElementExternal: (element: any) => element is PathItem;
declare const isPathsElement: (element: any) => boolean;
declare const isReferenceElement: (element: any) => boolean;
declare const isReferenceElementExternal: (element: any) => element is Reference;
declare const isRequestBodyElement: (element: any) => boolean;
declare const isResponseElement: (element: any) => boolean;
declare const isResponsesElement: (element: any) => boolean;
declare const isSchemaElement: (element: any) => boolean;
declare const isBooleanJsonSchemaElement: (element: any) => any;
declare const isSecurityRequirementElement: (element: any) => boolean;
declare const isServerElement: (element: any) => boolean;
declare const isServerVariableElement: (element: any) => boolean;
declare const isMediaTypeElement: (element: any) => boolean;

declare const isOpenApi3_0LikeElement: <T extends Element>(element: T) => boolean;
declare const isParameterLikeElement: <T extends Element>(element: T) => boolean;
declare const isReferenceLikeElement: <T extends Element>(element: T) => boolean;
declare const isRequestBodyLikeElement: <T extends Element>(element: T) => boolean;
declare const isResponseLikeElement: <T extends Element>(element: T) => boolean;
declare const isServerLikeElement: (element: any) => boolean;
declare const isTagLikeElement: (element: any) => boolean;
declare const isOpenApiExtension: (element: MemberElement) => boolean;

declare const AlternatingVisitor: stampit__default.Stamp<any>;

declare const FixedFieldsVisitor: stampit__default.Stamp<any>;

declare const MapVisitor: stampit__default.Stamp<any>;

declare const MixedFieldsVisitor: stampit__default.Stamp<any>;

declare const PatternedFieldsJsonObjectVisitor: stampit__default.Stamp<any>;

/**
 * This visitor is responsible for falling back to current traversed element
 * Given OpenApi3_0Visitor expects ObjectElement to be traversed. If
 * different Element is provided FallBackVisitor is responsible to assigning
 * this Element as current element.
 */
declare const FallbackVisitor: stampit__default.Stamp<any>;

/**
 * This is a base Type for every visitor that does
 * internal look-ups to retrieve other child visitors.
 */
declare const SpecificationVisitor: stampit__default.Stamp<any>;

declare const Visitor: stampit__default.Stamp<any>;

declare const getNodeType: <T extends Element>(element: T) => string | undefined;
/**
 * There are unfortunately two `LinkElement` types. One is from base namespace
 * and the other one if from this namespace. `LinkElement` from base namespace
 * is used extremely rarely, so it's almost always safe during traversing
 * to assume that `LinkElement` is element from this namespace.
 *
 * To be 100% sure that currently visiting `LinkElement` is from this namespace
 * use `isLinkElement` predicate from this namespace to assert for it.
 */
declare const keyMap: {
    ObjectElement: string[];
    ArrayElement: string[];
    MemberElement: string[];
    StringElement: never[];
    BooleanElement: never[];
    NumberElement: never[];
    NullElement: never[];
    RefElement: never[];
    LinkElement: never[];
    Annotation: never[];
    Comment: never[];
    ParseResultElement: string[];
    SourceMap: string[];
    CallbackElement: string[];
    ComponentsElement: string[];
    ContactElement: string[];
    DiscriminatorElement: string[];
    Encoding: string[];
    Example: string[];
    ExternalDocumentationElement: string[];
    HeaderElement: string[];
    InfoElement: string[];
    LicenseElement: string[];
    MediaTypeElement: string[];
    OAuthFlowElement: string[];
    OAuthFlowsElement: string[];
    OpenApi3_0Element: string[];
    OperationElement: string[];
    ParameterElement: string[];
    PathItemElement: string[];
    PathsElement: string[];
    ReferenceElement: string[];
    RequestBodyElement: string[];
    ResponseElement: string[];
    ResponsesElement: string[];
    SchemaElement: string[];
    SecurityRequirementElement: string[];
    SecuritySchemeElement: string[];
    ServerElement: string[];
    ServerVariableElement: string[];
    TagElement: string[];
};

declare class Callback extends ObjectElement {
    constructor(content?: Record<string, unknown>, meta?: Meta, attributes?: Attributes);
}

declare class Components extends ObjectElement {
    constructor(content?: Record<string, unknown>, meta?: Meta, attributes?: Attributes);
    get schemas(): ObjectElement | undefined;
    set schemas(schemas: ObjectElement | undefined);
    get responses(): ObjectElement | undefined;
    set responses(responses: ObjectElement | undefined);
    get parameters(): ObjectElement | undefined;
    set parameters(parameters: ObjectElement | undefined);
    get examples(): ObjectElement | undefined;
    set examples(examples: ObjectElement | undefined);
    get requestBodies(): ObjectElement | undefined;
    set requestBodies(requestBodies: ObjectElement | undefined);
    get headers(): ObjectElement | undefined;
    set headers(headers: ObjectElement | undefined);
    get securitySchemes(): ObjectElement | undefined;
    set securitySchemes(securitySchemes: ObjectElement | undefined);
    get links(): ObjectElement | undefined;
    set links(links: ObjectElement | undefined);
    get callbacks(): ObjectElement | undefined;
    set callbacks(callbacks: ObjectElement | undefined);
}

declare class Contact extends ObjectElement {
    constructor(content?: Record<string, unknown>, meta?: Meta, attributes?: Attributes);
    get name(): StringElement | undefined;
    set name(name: StringElement | undefined);
    get url(): StringElement | undefined;
    set url(url: StringElement | undefined);
    get email(): StringElement | undefined;
    set email(email: StringElement | undefined);
}

declare class Discriminator extends ObjectElement {
    constructor(content?: Record<string, unknown>, meta?: Meta, attributes?: Attributes);
    get propertyName(): StringElement | undefined;
    set propertyName(propertyName: StringElement | undefined);
    get mapping(): ObjectElement | undefined;
    set mapping(mapping: ObjectElement | undefined);
}

declare class Encoding extends ObjectElement {
    constructor(content?: Record<string, unknown>, meta?: Meta, attributes?: Attributes);
    get contentType(): StringElement | undefined;
    set contentType(contentType: StringElement | undefined);
    get headers(): ObjectElement | undefined;
    set headers(headers: ObjectElement | undefined);
    get style(): StringElement | undefined;
    set style(style: StringElement | undefined);
    get explode(): BooleanElement | undefined;
    set explode(explode: BooleanElement | undefined);
    get allowedReserved(): BooleanElement | undefined;
    set allowedReserved(allowedReserved: BooleanElement | undefined);
}

declare class Example extends ObjectElement {
    constructor(content?: Record<string, unknown>, meta?: Meta, attributes?: Attributes);
    get summary(): StringElement | undefined;
    set summary(summary: StringElement | undefined);
    get description(): StringElement | undefined;
    set description(description: StringElement | undefined);
    get value(): Element | undefined;
    set value(value: Element | undefined);
    get externalValue(): StringElement | undefined;
    set externalValue(externalValue: StringElement | undefined);
}

declare class Xml extends ObjectElement {
    constructor(content?: Record<string, unknown>, meta?: Meta, attributes?: Attributes);
    get name(): StringElement | undefined;
    set name(name: StringElement | undefined);
    get namespace(): StringElement | undefined;
    set namespace(namespace: StringElement | undefined);
    get prefix(): StringElement | undefined;
    set prefix(prefix: StringElement | undefined);
    get attribute(): BooleanElement | undefined;
    set attribute(attribute: BooleanElement | undefined);
    get wrapped(): BooleanElement | undefined;
    set wrapped(wrapped: BooleanElement | undefined);
}

declare class Schema extends JSONSchemaElement {
    constructor(content?: Record<string, unknown>, meta?: Meta, attributes?: Attributes);
    /**
     * Validation keywords for arrays
     */
    get additionalItems(): this | Reference | BooleanElement | undefined;
    set additionalItems(additionalItems: this | Reference | BooleanElement | undefined);
    get items(): this | Reference | undefined;
    set items(items: this | Reference | undefined);
    /**
     * Validation keywords for objects
     */
    get additionalProperties(): this | Reference | BooleanElement | undefined;
    set additionalProperties(additionalProperties: this | Reference | BooleanElement | undefined);
    /**
     *  Validation keywords for any instance type
     */
    get type(): StringElement | undefined;
    set type(type: StringElement | undefined);
    get not(): this | Reference | undefined;
    set not(not: this | Reference | undefined);
    /**
     * OpenAPI vocabulary
     */
    get nullable(): BooleanElement | undefined;
    set nullable(nullable: BooleanElement | undefined);
    get discriminator(): Discriminator | undefined;
    set discriminator(discriminator: Discriminator | undefined);
    get writeOnly(): BooleanElement | undefined;
    set writeOnly(writeOnly: BooleanElement | undefined);
    get xml(): Xml | undefined;
    set xml(xml: Xml | undefined);
    get externalDocs(): ExternalDocumentation | undefined;
    set externalDocs(externalDocs: ExternalDocumentation | undefined);
    get example(): Element | undefined;
    set example(example: Element | undefined);
    get deprecated(): BooleanElement | undefined;
    set deprecated(deprecated: BooleanElement | undefined);
}

declare class Header extends ObjectElement {
    constructor(content?: Record<string, unknown>, meta?: Meta, attributes?: Attributes);
    get required(): BooleanElement;
    set required(required: BooleanElement | undefined);
    get deprecated(): BooleanElement | undefined;
    set deprecated(deprecated: BooleanElement | undefined);
    get allowEmptyValue(): BooleanElement | undefined;
    set allowEmptyValue(allowEmptyValue: BooleanElement | undefined);
    get style(): StringElement | undefined;
    set style(style: StringElement | undefined);
    get explode(): BooleanElement | undefined;
    set explode(explode: BooleanElement | undefined);
    get allowReserved(): BooleanElement | undefined;
    set allowReserved(allowReserved: BooleanElement | undefined);
    get schema(): Schema | Reference | undefined;
    set schema(schema: Schema | Reference | undefined);
    get example(): Element | undefined;
    set example(example: Element | undefined);
    get examples(): ObjectElement | undefined;
    set examples(examples: ObjectElement | undefined);
    get contentProp(): ObjectElement | undefined;
    set contentProp(content: ObjectElement | undefined);
}

declare class License extends ObjectElement {
    constructor(content?: Record<string, unknown>, meta?: Meta, attributes?: Attributes);
    get name(): StringElement | undefined;
    set name(name: StringElement | undefined);
    get url(): StringElement | undefined;
    set url(url: StringElement | undefined);
}

declare class Info extends ObjectElement {
    constructor(content?: Record<string, unknown>, meta?: Meta, attributes?: Attributes);
    get title(): StringElement | undefined;
    set title(title: StringElement | undefined);
    get description(): StringElement | undefined;
    set description(description: StringElement | undefined);
    get termsOfService(): StringElement | undefined;
    set termsOfService(tos: StringElement | undefined);
    get contact(): Contact | undefined;
    set contact(contactElement: Contact | undefined);
    get license(): License | undefined;
    set license(licenseElement: License | undefined);
    get version(): StringElement | undefined;
    set version(version: StringElement | undefined);
}

declare class MediaType extends ObjectElement {
    constructor(content?: Record<string, unknown>, meta?: Meta, attributes?: Attributes);
    get schema(): Schema | Reference | undefined;
    set schema(schema: Schema | Reference | undefined);
    get example(): Element | undefined;
    set example(example: Element | undefined);
    get examples(): ObjectElement | undefined;
    set examples(examples: ObjectElement | undefined);
    get encoding(): ObjectElement | undefined;
    set encoding(encoding: ObjectElement | undefined);
}

declare class OAuthFlow extends ObjectElement {
    constructor(content?: Record<string, unknown>, meta?: Meta, attributes?: Attributes);
    get authorizationUrl(): StringElement | undefined;
    set authorizationUrl(authorizationUrl: StringElement | undefined);
    get tokenUrl(): StringElement | undefined;
    set tokenUrl(tokenUrl: StringElement | undefined);
    get refreshUrl(): StringElement | undefined;
    set refreshUrl(refreshUrl: StringElement | undefined);
    get scopes(): ObjectElement | undefined;
    set scopes(scopes: ObjectElement | undefined);
}

declare class OAuthFlows extends ObjectElement {
    constructor(content?: Record<string, unknown>, meta?: Meta, attributes?: Attributes);
    get implicit(): OAuthFlow | undefined;
    set implicit(implicit: OAuthFlow | undefined);
    get password(): OAuthFlow | undefined;
    set password(password: OAuthFlow | undefined);
    get clientCredentials(): OAuthFlow | undefined;
    set clientCredentials(clientCredentials: OAuthFlow | undefined);
    get authorizationCode(): OAuthFlow | undefined;
    set authorizationCode(authorizationCode: OAuthFlow | undefined);
}

declare class Openapi extends StringElement {
    constructor(content?: string, meta?: Meta, attributes?: Attributes);
}

declare class Paths extends ObjectElement {
    constructor(content?: Record<string, unknown>, meta?: Meta, attributes?: Attributes);
}

declare class OpenApi3_0 extends ObjectElement {
    constructor(content?: Record<string, unknown>, meta?: Meta, attributes?: Attributes);
    get openapi(): Openapi | undefined;
    set openapi(openapi: Openapi | undefined);
    get info(): Info | undefined;
    set info(info: Info | undefined);
    get servers(): ArrayElement | undefined;
    set servers(servers: ArrayElement | undefined);
    get paths(): Paths | undefined;
    set paths(paths: Paths | undefined);
    get components(): Components | undefined;
    set components(components: Components | undefined);
    get security(): ArrayElement | undefined;
    set security(security: ArrayElement | undefined);
    get tags(): ArrayElement | undefined;
    set tags(tags: ArrayElement | undefined);
    get externalDocs(): ExternalDocumentation | undefined;
    set externalDocs(externalDocs: ExternalDocumentation | undefined);
}

declare class Parameter extends ObjectElement {
    constructor(content?: Record<string, unknown>, meta?: Meta, attributes?: Attributes);
    get name(): StringElement | undefined;
    set name(name: StringElement | undefined);
    get in(): StringElement | undefined;
    set in(val: StringElement | undefined);
    get required(): BooleanElement;
    set required(required: BooleanElement);
    get deprecated(): BooleanElement;
    set deprecated(deprecated: BooleanElement);
    get allowEmptyValue(): BooleanElement | undefined;
    set allowEmptyValue(allowEmptyValue: BooleanElement | undefined);
    get style(): StringElement | undefined;
    set style(style: StringElement | undefined);
    get explode(): BooleanElement | undefined;
    set explode(explode: BooleanElement | undefined);
    get allowReserved(): BooleanElement | undefined;
    set allowReserved(allowReserved: BooleanElement | undefined);
    get schema(): Schema | Reference | undefined;
    set schema(schema: Schema | Reference | undefined);
    get example(): Element | undefined;
    set example(example: Element | undefined);
    get examples(): ObjectElement | undefined;
    set examples(examples: ObjectElement | undefined);
    get contentProp(): ObjectElement | undefined;
    set contentProp(content: ObjectElement | undefined);
}

declare class SecurityRequirement extends ObjectElement {
    constructor(content?: Record<string, unknown>, meta?: Meta, attributes?: Attributes);
}

declare class SecurityScheme extends ObjectElement {
    constructor(content?: Record<string, unknown>, meta?: Meta, attributes?: Attributes);
    get type(): StringElement | undefined;
    set type(type: StringElement | undefined);
    get description(): StringElement | undefined;
    set description(description: StringElement | undefined);
    get name(): StringElement | undefined;
    set name(name: StringElement | undefined);
    get in(): StringElement | undefined;
    set in(inVal: StringElement | undefined);
    get scheme(): StringElement | undefined;
    set scheme(scheme: StringElement | undefined);
    get bearerFormat(): StringElement | undefined;
    set bearerFormat(bearerFormat: StringElement | undefined);
    get flows(): OAuthFlows | undefined;
    set flows(flows: OAuthFlows | undefined);
    get openIdConnectUrl(): StringElement | undefined;
    set openIdConnectUrl(openIdConnectUrl: StringElement | undefined);
}

declare class ServerVariable extends ObjectElement {
    constructor(content?: Record<string, unknown>, meta?: Meta, attributes?: Attributes);
    get enum(): ArrayElement | undefined;
    set enum(value: ArrayElement | undefined);
    get default(): StringElement | undefined;
    set default(value: StringElement | undefined);
    get description(): StringElement | undefined;
    set description(description: StringElement | undefined);
}

declare class Tag extends ObjectElement {
    constructor(content?: Record<string, unknown>, meta?: Meta, attributes?: Attributes);
    get name(): StringElement | undefined;
    set name(name: StringElement | undefined);
    get description(): StringElement | undefined;
    set description(description: StringElement | undefined);
    get externalDocs(): ExternalDocumentation | undefined;
    set externalDocs(externalDocs: ExternalDocumentation | undefined);
}

declare class ComponentsCallbacks extends ObjectElement {
    static primaryClass: string;
    constructor(content?: Record<string, unknown>, meta?: Meta, attributes?: Attributes);
}

declare class ComponentsExamples extends ObjectElement {
    static primaryClass: string;
    constructor(content?: Record<string, unknown>, meta?: Meta, attributes?: Attributes);
}

declare class ComponentsHeaders extends ObjectElement {
    static primaryClass: string;
    constructor(content?: Record<string, unknown>, meta?: Meta, attributes?: Attributes);
}

declare class ComponentsLinks extends ObjectElement {
    static primaryClass: string;
    constructor(content?: Record<string, unknown>, meta?: Meta, attributes?: Attributes);
}

declare class ComponentsParameters extends ObjectElement {
    static primaryClass: string;
    constructor(content?: Record<string, unknown>, meta?: Meta, attributes?: Attributes);
}

declare class ComponentsRequestBodies extends ObjectElement {
    static primaryClass: string;
    constructor(content?: Record<string, unknown>, meta?: Meta, attributes?: Attributes);
}

declare class ComponentsResponses extends ObjectElement {
    static primaryClass: string;
    constructor(content?: Record<string, unknown>, meta?: Meta, attributes?: Attributes);
}

declare class ComponentsSchemas extends ObjectElement {
    static primaryClass: string;
    constructor(content?: Record<string, unknown>, meta?: Meta, attributes?: Attributes);
}

declare class ComponentsSecuritySchemes extends ObjectElement {
    static primaryClass: string;
    constructor(content?: Record<string, unknown>, meta?: Meta, attributes?: Attributes);
}

declare class DiscriminatorMapping extends ObjectElement {
    static primaryClass: string;
    constructor(content?: Record<string, unknown>, meta?: Meta, attributes?: Attributes);
}

declare class EncodingHeaders extends ObjectElement {
    static primaryClass: string;
    constructor(content?: Record<string, unknown>, meta?: Meta, attributes?: Attributes);
}

declare class HeaderContent extends ObjectElement {
    static primaryClass: string;
    constructor(content?: Record<string, unknown>, meta?: Meta, attributes?: Attributes);
}

declare class HeaderExamples extends ObjectElement {
    static primaryClass: string;
    constructor(content?: Record<string, unknown>, meta?: Meta, attributes?: Attributes);
}

declare class LinkParameters extends ObjectElement {
    static primaryClass: string;
    constructor(content?: Record<string, unknown>, meta?: Meta, attributes?: Attributes);
}

declare class MediaTypeEncoding extends ObjectElement {
    static primaryClass: string;
    constructor(content?: Record<string, unknown>, meta?: Meta, attributes?: Attributes);
}

declare class MediaTypeExamples extends ObjectElement {
    static primaryClass: string;
    constructor(content?: Record<string, unknown>, meta?: Meta, attributes?: Attributes);
}

declare class OAuthFlowScopes extends ObjectElement {
    static primaryClass: string;
    constructor(content?: Record<string, unknown>, meta?: Meta, attributes?: Attributes);
}

declare class OperationCallbacks extends ObjectElement {
    static primaryClass: string;
    constructor(content?: Record<string, unknown>, meta?: Meta, attributes?: Attributes);
}

declare class OperationParameters extends ArrayElement {
    static primaryClass: string;
    constructor(content?: Array<unknown>, meta?: Meta, attributes?: Attributes);
}

declare class OperationSecurity extends ArrayElement {
    static primaryClass: string;
    constructor(content?: Array<unknown>, meta?: Meta, attributes?: Attributes);
}

declare class OperationServers extends ArrayElement {
    static primaryClass: string;
    constructor(content?: Array<unknown>, meta?: Meta, attributes?: Attributes);
}

declare class OperationTags extends ArrayElement {
    static primaryClass: string;
    constructor(content?: Array<unknown>, meta?: Meta, attributes?: Attributes);
}

declare class ParameterContent extends ObjectElement {
    static primaryClass: string;
    constructor(content?: Record<string, unknown>, meta?: Meta, attributes?: Attributes);
}

declare class ParameterExamples extends ObjectElement {
    static primaryClass: string;
    constructor(content?: Record<string, unknown>, meta?: Meta, attributes?: Attributes);
}

declare class PathItemParameters extends ArrayElement {
    static primaryClass: string;
    constructor(content?: Array<unknown>, meta?: Meta, attributes?: Attributes);
}

declare class PathItemServers extends ArrayElement {
    static primaryClass: string;
    constructor(content?: Array<unknown>, meta?: Meta, attributes?: Attributes);
}

declare class RequestBodyContent extends ObjectElement {
    static primaryClass: string;
    constructor(content?: Record<string, unknown>, meta?: Meta, attributes?: Attributes);
}

declare class ResponseContent extends ObjectElement {
    static primaryClass: string;
    constructor(content?: Record<string, unknown>, meta?: Meta, attributes?: Attributes);
}

declare class ResponseHeaders extends ObjectElement {
    static primaryClass: string;
    constructor(content?: Record<string, unknown>, meta?: Meta, attributes?: Attributes);
}

declare class ResponseLinks extends ObjectElement {
    static primaryClass: string;
    constructor(content?: Record<string, unknown>, meta?: Meta, attributes?: Attributes);
}

declare class Security extends ArrayElement {
    static primaryClass: string;
    constructor(content?: Array<unknown>, meta?: Meta, attributes?: Attributes);
}

declare class Servers extends ArrayElement {
    static primaryClass: string;
    constructor(content?: Array<unknown>, meta?: Meta, attributes?: Attributes);
}

declare class ServerVariables extends ObjectElement {
    static primaryClass: string;
    constructor(content?: Record<string, unknown>, meta?: Meta, attributes?: Attributes);
}

declare class Tags extends ArrayElement {
    static primaryClass: string;
    constructor(content?: Array<unknown>, meta?: Meta, attributes?: Attributes);
}

export { AlternatingVisitor, Callback as CallbackElement, ComponentsCallbacks as ComponentsCallbacksElement, Components as ComponentsElement, ComponentsExamples as ComponentsExamplesElement, ComponentsHeaders as ComponentsHeadersElement, ComponentsLinks as ComponentsLinksElement, ComponentsParameters as ComponentsParametersElement, ComponentsRequestBodies as ComponentsRequestBodiesElement, ComponentsResponses as ComponentsResponsesElement, ComponentsSchemas as ComponentsSchemasElement, ComponentsSecuritySchemes as ComponentsSecuritySchemesElement, Contact as ContactElement, Discriminator as DiscriminatorElement, DiscriminatorMapping as DiscriminatorMappingElement, Encoding as EncodingElement, EncodingHeaders as EncodingHeadersElement, Example as ExampleElement, ExternalDocumentation as ExternalDocumentationElement, FallbackVisitor, FixedFieldsVisitor, HeaderContent as HeaderContentElement, Header as HeaderElement, HeaderExamples as HeaderExamplesElement, Info as InfoElement, License as LicenseElement, Link as LinkElement, LinkParameters as LinkParametersElement, MapVisitor, MediaType as MediaTypeElement, MediaTypeEncoding as MediaTypeEncodingElement, MediaTypeExamples as MediaTypeExamplesElement, MixedFieldsVisitor, OAuthFlow as OAuthFlowElement, OAuthFlowScopes as OAuthFlowScopesElement, OAuthFlows as OAuthFlowsElement, OpenAPIMediaTypes, OpenApi3_0 as OpenApi3_0Element, Openapi as OpenapiElement, OperationCallbacks as OperationCallbacksElement, Operation as OperationElement, OperationParameters as OperationParametersElement, OperationSecurity as OperationSecurityElement, OperationServers as OperationServersElement, OperationTags as OperationTagsElement, ParameterContent as ParameterContentElement, Parameter as ParameterElement, ParameterExamples as ParameterExamplesElement, PathItem as PathItemElement, PathItemParameters as PathItemParametersElement, PathItemServers as PathItemServersElement, Paths as PathsElement, PatternedFieldsJsonObjectVisitor as PatternedFieldsVisitor, Reference as ReferenceElement, RequestBodyContent as RequestBodyContentElement, RequestBody as RequestBodyElement, ResponseContent as ResponseContentElement, Response as ResponseElement, ResponseHeaders as ResponseHeadersElement, ResponseLinks as ResponseLinksElement, Responses as ResponsesElement, Schema as SchemaElement, Security as SecurityElement, SecurityRequirement as SecurityRequirementElement, SecurityScheme as SecuritySchemeElement, Server as ServerElement, ServerVariable as ServerVariableElement, ServerVariables as ServerVariablesElement, Servers as ServersElement, SpecificationVisitor, Tag as TagElement, Tags as TagsElement, Visitor, Xml as XmlElement, createRefractor, openApi3_0 as default, getNodeType, isBooleanJsonSchemaElement, isCallbackElement, isComponentsElement, isContactElement, isExampleElement, isExternalDocumentationElement, isInfoElement, isLicenseElement, isLinkElement, isLinkElementExternal, isMediaTypeElement, isOpenApi3_0Element, isOpenApi3_0LikeElement, isOpenApiExtension, isOpenapiElement, isOperationElement, isParameterElement, isParameterLikeElement, isPathItemElement, isPathItemElementExternal, isPathsElement, isReferenceElement, isReferenceElementExternal, isReferenceLikeElement, isRequestBodyElement, isRequestBodyLikeElement, isResponseElement, isResponseLikeElement, isResponsesElement, isSchemaElement, isSecurityRequirementElement, isServerElement, isServerLikeElement, isServerVariableElement, isTagLikeElement, keyMap, mediaTypes, refract, plugin as refractorPluginReplaceEmptyElement, specification as specificationObj };
