"use strict";

var _interopRequireDefault = require("@babel/runtime-corejs3/helpers/interopRequireDefault");
exports.__esModule = true;
exports.default = void 0;
var _stampit = _interopRequireDefault(require("stampit"));
var _ramda = require("ramda");
var _ramdaAdjunct = require("ramda-adjunct");
var _apidomCore = require("@swagger-api/apidom-core");
var _SpecificationVisitor = _interopRequireDefault(require("../SpecificationVisitor.cjs"));
const AlternatingVisitor = (0, _stampit.default)(_SpecificationVisitor.default, {
  props: {
    alternator: []
  },
  methods: {
    enter(element) {
      const functions = this.alternator.map(({
        predicate,
        specPath
      }) => (0, _ramda.ifElse)(predicate, (0, _ramda.always)(specPath), _ramdaAdjunct.stubUndefined));
      const specPath = (0, _ramdaAdjunct.dispatch)(functions)(element);
      this.element = this.toRefractedElement(specPath, element);
      return _apidomCore.BREAK;
    }
  }
});
var _default = AlternatingVisitor;
exports.default = _default;