"use strict";

var _interopRequireDefault = require("@babel/runtime-corejs3/helpers/interopRequireDefault");
exports.__esModule = true;
exports.default = void 0;
var _stampit = _interopRequireDefault(require("stampit"));
var _ramdaAdjunct = require("ramda-adjunct");
var _apidomCore = require("@swagger-api/apidom-core");
var _SpecificationVisitor = _interopRequireDefault(require("../SpecificationVisitor.cjs"));
var _predicates = require("../../predicates.cjs");
const FixedFieldsVisitor = (0, _stampit.default)(_SpecificationVisitor.default, {
  props: {
    specPath: _ramdaAdjunct.noop,
    ignoredFields: [],
    canSupportSpecificationExtensions: true,
    specificationExtensionPredicate: _predicates.isOpenApiExtension
  },
  init({
    // @ts-ignore
    specPath = this.specPath,
    // @ts-ignore
    ignoredFields = this.ignoredFields,
    // @ts-ignore
    canSupportSpecificationExtensions = this.canSupportSpecificationExtensions,
    // @ts-ignore
    specificationExtensionPredicate = this.specificationExtensionPredicate
  } = {}) {
    this.specPath = specPath;
    this.ignoredFields = ignoredFields;
    this.canSupportSpecificationExtensions = canSupportSpecificationExtensions;
    this.specificationExtensionPredicate = specificationExtensionPredicate;
  },
  methods: {
    ObjectElement(objectElement) {
      const specPath = this.specPath(objectElement);
      const fields = this.retrieveFixedFields(specPath);
      objectElement.forEach((value, key, memberElement) => {
        if ((0, _apidomCore.isStringElement)(key) && fields.includes(key.toValue()) && !this.ignoredFields.includes(key.toValue())) {
          const fixedFieldElement = this.toRefractedElement([...specPath, 'fixedFields', key.toValue()], value);
          const newMemberElement = new _apidomCore.MemberElement(key.clone(), fixedFieldElement);
          this.copyMetaAndAttributes(memberElement, newMemberElement);
          newMemberElement.classes.push('fixed-field');
          this.element.content.push(newMemberElement);
        } else if (this.canSupportSpecificationExtensions && this.specificationExtensionPredicate(memberElement)) {
          const extensionElement = this.toRefractedElement(['document', 'extension'], memberElement);
          this.element.content.push(extensionElement);
        } else if (!this.ignoredFields.includes(key.toValue())) {
          this.element.content.push(memberElement.clone());
        }
      });
      this.copyMetaAndAttributes(objectElement, this.element);
      return _apidomCore.BREAK;
    }
  }
});
var _default = FixedFieldsVisitor;
exports.default = _default;