"use strict";

var _interopRequireDefault = require("@babel/runtime-corejs3/helpers/interopRequireDefault");
exports.__esModule = true;
exports.default = void 0;
var _stampit = _interopRequireDefault(require("stampit"));
var _apidomCore = require("@swagger-api/apidom-core");
var _MapVisitor = _interopRequireDefault(require("../generics/MapVisitor.cjs"));
var _FallbackVisitor = _interopRequireDefault(require("../FallbackVisitor.cjs"));
var _predicates = require("../../predicates.cjs");
var _predicates2 = require("../../../predicates.cjs");
const ExamplesVisitor = (0, _stampit.default)(_MapVisitor.default, _FallbackVisitor.default, {
  props: {
    specPath: element => (0, _predicates.isReferenceLikeElement)(element) ? ['document', 'objects', 'Reference'] : ['document', 'objects', 'Example'],
    canSupportSpecificationExtensions: true
  },
  init() {
    this.element = new _apidomCore.ObjectElement();
    this.element.classes.push('examples');
  },
  methods: {
    ObjectElement(objectElement) {
      // @ts-ignore
      const result = _MapVisitor.default.compose.methods.ObjectElement.call(this, objectElement);
      this.element.filter(_predicates2.isReferenceElement).forEach(referenceElement => {
        referenceElement.setMetaProperty('referenced-element', 'example');
      });
      return result;
    }
  }
});
var _default = ExamplesVisitor;
exports.default = _default;