"use strict";

var _interopRequireDefault = require("@babel/runtime-corejs3/helpers/interopRequireDefault");
exports.__esModule = true;
exports.default = void 0;
var _stampit = _interopRequireDefault(require("stampit"));
var _ramda = require("ramda");
var _apidomCore = require("@swagger-api/apidom-core");
var _PathItem = _interopRequireDefault(require("../../../../elements/PathItem.cjs"));
var _predicates = require("../../../../predicates.cjs");
var _FixedFieldsVisitor = _interopRequireDefault(require("../../generics/FixedFieldsVisitor.cjs"));
var _FallbackVisitor = _interopRequireDefault(require("../../FallbackVisitor.cjs"));
const PathItemVisitor = (0, _stampit.default)(_FixedFieldsVisitor.default, _FallbackVisitor.default, {
  props: {
    specPath: (0, _ramda.always)(['document', 'objects', 'PathItem'])
  },
  init() {
    this.element = new _PathItem.default();
  },
  methods: {
    ObjectElement(objectElement) {
      // @ts-ignore
      const result = _FixedFieldsVisitor.default.compose.methods.ObjectElement.call(this, objectElement);

      // decorate Operation elements with HTTP method
      this.element.filter(_predicates.isOperationElement).forEach((operationElement, httpMethodElementCI) => {
        const httpMethodElementCS = httpMethodElementCI.clone();
        httpMethodElementCS.content = httpMethodElementCS.toValue().toUpperCase();
        operationElement.setMetaProperty('http-method', httpMethodElementCS);
      });

      // mark this PathItemElement with reference metadata
      if ((0, _apidomCore.isStringElement)(this.element.$ref)) {
        this.element.classes.push('reference-element');
      }
      return result;
    }
  }
});
var _default = PathItemVisitor;
exports.default = _default;