"use strict";

var _interopRequireDefault = require("@babel/runtime-corejs3/helpers/interopRequireDefault");
exports.__esModule = true;
exports.default = void 0;
var _stampit = _interopRequireDefault(require("stampit"));
var _ramda = require("ramda");
var _apidomCore = require("@swagger-api/apidom-core");
var _Reference = _interopRequireDefault(require("../../../../elements/Reference.cjs"));
var _FixedFieldsVisitor = _interopRequireDefault(require("../../generics/FixedFieldsVisitor.cjs"));
var _FallbackVisitor = _interopRequireDefault(require("../../FallbackVisitor.cjs"));
const ReferenceVisitor = (0, _stampit.default)(_FixedFieldsVisitor.default, _FallbackVisitor.default, {
  props: {
    specPath: (0, _ramda.always)(['document', 'objects', 'Reference']),
    canSupportSpecificationExtensions: false
  },
  init() {
    this.element = new _Reference.default();
  },
  methods: {
    ObjectElement(objectElement) {
      // @ts-ignore
      const result = _FixedFieldsVisitor.default.compose.methods.ObjectElement.call(this, objectElement);

      // mark this ReferenceElement with reference metadata
      if ((0, _apidomCore.isStringElement)(this.element.$ref)) {
        this.element.classes.push('reference-element');
      }
      return result;
    }
  }
});
var _default = ReferenceVisitor;
exports.default = _default;