"use strict";

var _interopRequireDefault = require("@babel/runtime-corejs3/helpers/interopRequireDefault");
exports.__esModule = true;
exports.default = void 0;
var _stampit = _interopRequireDefault(require("stampit"));
var _ramda = require("ramda");
var _apidomCore = require("@swagger-api/apidom-core");
var _Response = _interopRequireDefault(require("../../../../elements/Response.cjs"));
var _FixedFieldsVisitor = _interopRequireDefault(require("../../generics/FixedFieldsVisitor.cjs"));
var _FallbackVisitor = _interopRequireDefault(require("../../FallbackVisitor.cjs"));
var _predicates = require("../../../../predicates.cjs");
const ResponseVisitor = (0, _stampit.default)(_FixedFieldsVisitor.default, _FallbackVisitor.default, {
  props: {
    specPath: (0, _ramda.always)(['document', 'objects', 'Response'])
  },
  init() {
    this.element = new _Response.default();
  },
  methods: {
    ObjectElement(objectElement) {
      // @ts-ignore
      const result = _FixedFieldsVisitor.default.compose.methods.ObjectElement.call(this, objectElement);

      // decorate every MediaTypeElement with media type metadata
      if ((0, _apidomCore.isObjectElement)(this.element.contentProp)) {
        this.element.contentProp.filter(_predicates.isMediaTypeElement).forEach((mediaTypeElement, key) => {
          mediaTypeElement.setMetaProperty('media-type', key.toValue());
        });
      }

      // decorate every MediaTypeElement with media type metadata
      if ((0, _apidomCore.isObjectElement)(this.element.headers)) {
        this.element.headers.filter(_predicates.isHeaderElement).forEach((headerElement, key) => {
          headerElement.setMetaProperty('header-name', key.toValue());
        });
      }
      return result;
    }
  }
});
var _default = ResponseVisitor;
exports.default = _default;