import _defineProperty from "@babel/runtime-corejs3/helpers/esm/defineProperty";
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
import stampit from 'stampit';
import { pathSatisfies, path, pick, pipe, keys } from 'ramda';
import { isFunction, isUndefined } from 'ramda-adjunct';
import { visit } from '@swagger-api/apidom-core';
import Visitor from "./Visitor.js";
import { keyMap, getNodeType } from "../../traversal/visitor.js";
/**
 * This is a base Type for every visitor that does
 * internal look-ups to retrieve other child visitors.
 */
const SpecificationVisitor = stampit(Visitor, {
  props: {
    passingOptionsNames: ['specObj', 'openApiGenericElement', 'openApiSemanticElement'],
    specObj: null,
    openApiGenericElement: null,
    openApiSemanticElement: null
  },
  init({
    // @ts-ignore
    specObj = this.specObj,
    // @ts-ignore
    openApiGenericElement = this.openApiGenericElement,
    // @ts-ignore
    openApiSemanticElement = this.openApiSemanticElement
  }) {
    this.specObj = specObj;
    this.openApiGenericElement = openApiGenericElement;
    this.openApiSemanticElement = openApiSemanticElement;
  },
  methods: {
    retrievePassingOptions() {
      return pick(this.passingOptionsNames, this);
    },
    retrieveFixedFields(specPath) {
      return pipe(path(['visitors', ...specPath, 'fixedFields']), keys)(this.specObj);
    },
    retrieveVisitor(specPath) {
      if (pathSatisfies(isFunction, ['visitors', ...specPath], this.specObj)) {
        return path(['visitors', ...specPath], this.specObj);
      }
      return path(['visitors', ...specPath, '$visitor'], this.specObj);
    },
    retrieveVisitorInstance(specPath, options = {}) {
      const passingOpts = this.retrievePassingOptions();
      return this.retrieveVisitor(specPath)(_objectSpread(_objectSpread({}, passingOpts), options));
    },
    toRefractedElement(specPath, element, options = {}) {
      /**
       * This is `Visitor shortcut`: mechanism for short circuiting the traversal and replacing
       * it by basic node cloning.
       *
       * Visiting the element is equivalent to cloning it  if the prototype of a visitor
       * is the same as the prototype of FallbackVisitor. If that's the case, we can avoid
       * bootstrapping the traversal cycle for fields that don't require any special visiting.
       */
      const visitor = this.retrieveVisitorInstance(specPath, options);
      const visitorPrototype = Object.getPrototypeOf(visitor);
      if (isUndefined(this.fallbackVisitorPrototype)) {
        this.fallbackVisitorPrototype = Object.getPrototypeOf(this.retrieveVisitorInstance(['value']));
      }
      if (this.fallbackVisitorPrototype === visitorPrototype) {
        return element.clone();
      }

      // standard processing continues
      visit(element, visitor, _objectSpread({
        keyMap,
        nodeTypeGetter: getNodeType
      }, options));
      return visitor.element;
    }
  }
});
export default SpecificationVisitor;