import stampit from 'stampit';
import { ifElse, always } from 'ramda';
import { dispatch, stubUndefined } from 'ramda-adjunct';
import { BREAK } from '@swagger-api/apidom-core';
import SpecificationVisitor from "../SpecificationVisitor.js";
const AlternatingVisitor = stampit(SpecificationVisitor, {
  props: {
    alternator: []
  },
  methods: {
    enter(element) {
      const functions = this.alternator.map(({
        predicate,
        specPath
      }) => ifElse(predicate, always(specPath), stubUndefined));
      const specPath = dispatch(functions)(element);
      this.element = this.toRefractedElement(specPath, element);
      return BREAK;
    }
  }
});
export default AlternatingVisitor;