import stampit from 'stampit';
import { BREAK } from '@swagger-api/apidom-core';
import FallbackVisitor from "../FallbackVisitor.js";
import SpecificationVisitor from "../SpecificationVisitor.js";
import OpenapiElement from "../../../elements/Openapi.js";
const OpenapiVisitor = stampit(SpecificationVisitor, FallbackVisitor, {
  methods: {
    StringElement(stringElement) {
      const openapiElement = new OpenapiElement(stringElement.toValue());
      this.copyMetaAndAttributes(stringElement, openapiElement);
      this.element = openapiElement;
      return BREAK;
    }
  }
});
export default OpenapiVisitor;