import stampit from 'stampit';
import { BREAK } from '@swagger-api/apidom-core';
import TagsElement from "../../../elements/nces/Tags.js";
import SpecificationVisitor from "../SpecificationVisitor.js";
import FallbackVisitor from "../FallbackVisitor.js";
import { isTagLikeElement } from "../../predicates.js";
const TagsVisitor = stampit(SpecificationVisitor, FallbackVisitor, {
  init() {
    this.element = new TagsElement();
  },
  methods: {
    ArrayElement(arrayElement) {
      arrayElement.forEach(item => {
        const specPath = isTagLikeElement(item) ? ['document', 'objects', 'Tag'] : ['value'];
        const element = this.toRefractedElement(specPath, item);
        this.element.push(element);
      });
      this.copyMetaAndAttributes(arrayElement, this.element);
      return BREAK;
    }
  }
});
export default TagsVisitor;