import stampit from 'stampit';
import ComponentsParametersElement from "../../../../elements/nces/ComponentsParameters.js";
import MapVisitor from "../../generics/MapVisitor.js";
import FallbackVisitor from "../../FallbackVisitor.js";
import { isReferenceLikeElement } from "../../../predicates.js";
import { isReferenceElement } from "../../../../predicates.js";
const ParametersVisitor = stampit(MapVisitor, FallbackVisitor, {
  props: {
    specPath: element => {
      // eslint-disable-next-line no-nested-ternary
      return isReferenceLikeElement(element) ? ['document', 'objects', 'Reference'] : ['document', 'objects', 'Parameter'];
    }
  },
  init() {
    this.element = new ComponentsParametersElement();
  },
  methods: {
    ObjectElement(objectElement) {
      // @ts-ignore
      const result = MapVisitor.compose.methods.ObjectElement.call(this, objectElement);

      // decorate every ReferenceElement with metadata about their referencing type
      this.element.filter(isReferenceElement).forEach(referenceElement => {
        referenceElement.setMetaProperty('referenced-element', 'parameter');
      });
      return result;
    }
  }
});
export default ParametersVisitor;