import stampit from 'stampit';
import MapVisitor from "../../generics/MapVisitor.js";
import FallbackVisitor from "../../FallbackVisitor.js";
import { isReferenceLikeElement } from "../../../predicates.js";
import { isHeaderElement, isReferenceElement } from "../../../../predicates.js";
import EncodingHeadersElement from "../../../../elements/nces/EncodingHeaders.js";
const HeadersVisitor = stampit(MapVisitor, FallbackVisitor, {
  props: {
    specPath: element => isReferenceLikeElement(element) ? ['document', 'objects', 'Reference'] : ['document', 'objects', 'Header']
  },
  init() {
    this.element = new EncodingHeadersElement();
  },
  methods: {
    ObjectElement(objectElement) {
      // @ts-ignore
      const result = MapVisitor.compose.methods.ObjectElement.call(this, objectElement);

      // decorate every ReferenceElement with metadata about their referencing type
      this.element.filter(isReferenceElement).forEach(referenceElement => {
        referenceElement.setMetaProperty('referenced-element', 'header');
      });

      // decorate every HeaderElement with metadata about their name
      this.element.forEach((value, key) => {
        if (!isHeaderElement(value)) return;
        const headerName = key.toValue();
        value.setMetaProperty('headerName', headerName);
      });
      return result;
    }
  }
});
export default HeadersVisitor;