import stampit from 'stampit';
import { BREAK } from '@swagger-api/apidom-core';
import { specificationObj as JSONSchemaDraft4Specification } from '@swagger-api/apidom-ns-json-schema-draft-4';
import { isReferenceElement } from "../../../../predicates.js";
const {
  items: JSONSchemaItemsVisitor
} = JSONSchemaDraft4Specification.visitors.document.objects.JSONSchema.fixedFields;
const ItemsVisitor = stampit(JSONSchemaItemsVisitor, {
  methods: {
    ObjectElement(objectElement) {
      // @ts-ignore
      const result = JSONSchemaItemsVisitor.compose.methods.ObjectElement.call(this, objectElement);
      if (isReferenceElement(this.element)) {
        this.element.setMetaProperty('referenced-element', 'schema');
      }
      return result;
    },
    ArrayElement(arrayElement) {
      this.element = arrayElement.clone();
      return BREAK;
    }
  }
});
export default ItemsVisitor;